/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.publisher;

import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureService;
import ch.admin.bit.jeap.messaging.kafka.signature.common.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.ByteSigner;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignatureCertificateHandling;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignatureInjector;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignaturePublisherProperties;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import lombok.Generated;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;

public class DefaultSignatureService
implements SignatureService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSignatureService.class);
    private final SignaturePublisherProperties properties;
    private final TaskScheduler taskScheduler;
    private final SignatureMetricsService signatureMetricsService;
    private final String applicationName;
    private SignatureInjector signatureInjector;
    private SignatureCertificateHandling certificateHandling;

    public DefaultSignatureService(SignaturePublisherProperties properties, TaskScheduler taskScheduler, Optional<SignatureMetricsService> signatureMetricsService, @Value(value="${spring.application.name}") String applicationName) {
        this.properties = properties;
        this.taskScheduler = taskScheduler;
        this.signatureMetricsService = signatureMetricsService.orElse(null);
        this.applicationName = applicationName;
    }

    @PostConstruct
    void init() {
        this.properties.checkAndLogSigningDisabled();
        if (this.properties.isSigningEnabled()) {
            CryptoProviderHelper.installCryptoProvider();
            this.certificateHandling = SignatureCertificateHandling.create(this.properties.signatureCertificate(), this.taskScheduler, this.signatureMetricsService, this.applicationName);
            this.signatureInjector = new SignatureInjector(new ByteSigner(this.properties.signatureKey()), this.certificateHandling.getCertificateSerialNumber());
        }
    }

    @Override
    public void injectSignature(Headers headers, byte[] bytesToSign, boolean isKey) {
        if (!this.properties.isSigningEnabled()) {
            return;
        }
        this.signatureInjector.injectSignature(headers, bytesToSign, isKey);
    }
}

