/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.tracing;

import brave.messaging.MessagingTracing;
import brave.propagation.TraceContext;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceContextUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceContextUpdater.class);
    private final MessagingTracing messagingTracing;

    public void setTraceContext(TraceContext traceContext) {
        TraceContext.Builder builder = brave.propagation.TraceContext.newBuilder().spanId(traceContext.getSpanId().longValue()).traceId(traceContext.getTraceId().longValue()).parentId(traceContext.getParentSpanId());
        if (traceContext.getTraceIdHigh() != null) {
            builder.traceIdHigh(traceContext.getTraceIdHigh().longValue());
        }
        this.messagingTracing.tracing().currentTraceContext().newScope(builder.build());
        brave.propagation.TraceContext currentTraceContext = this.messagingTracing.tracing().currentTraceContext().get();
        log.debug("TraceContext updated with trace id = {}, trace id string = {}, span id = {}, span id string = {}, parent id = {}, parent id string = {}.", new Object[]{currentTraceContext.traceId(), currentTraceContext.traceIdString(), currentTraceContext.spanId(), currentTraceContext.spanIdString(), currentTraceContext.parentId(), currentTraceContext.parentIdString()});
    }

    @Generated
    public TraceContextUpdater(MessagingTracing messagingTracing) {
        this.messagingTracing = messagingTracing;
    }
}

