/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.publisher;

import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.common.CertificateHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.common.SignatureCertificate;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateException;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

class SignatureCertificateHandling {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignatureCertificateHandling.class);
    private static final Duration TASK_INTERVAL = Duration.ofHours(1L);
    private final SignatureCertificate certificate;
    private final TaskScheduler taskScheduler;
    private final SignatureMetricsService signatureMetricsService;
    private final String applicationName;
    private AtomicLong validityDaysRemaining;

    public byte[] getCertificateSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    private void initialCheck() {
        this.checkCommonName();
        this.checkCertificateValidity();
    }

    private void checkCommonName() {
        if (!Objects.equals(this.applicationName, CertificateHelper.getCommonName(this.certificate.getSubjectDistinguishedName()))) {
            log.error("Application name {} does not match CN of certificate {}", (Object)this.applicationName, (Object)this.certificate.getSubjectDistinguishedName());
            throw CertificateException.certificateCnNotValid(this.applicationName, this.certificate.getSubjectDistinguishedName());
        }
    }

    private void checkCertificateValidity() {
        if (this.certificate.isExpired()) {
            log.warn("Signing Certificate is expired, please renew");
        }
        if (this.certificate.isNotYetValid()) {
            log.warn("Signing Certificate is not yet valid");
        }
    }

    private void init() {
        this.initMetrics();
        this.initTaskScheduler();
    }

    private void initMetrics() {
        this.validityDaysRemaining = new AtomicLong(this.certificate.getValidityRemainingDays());
        this.signatureMetricsService.initCertificateValidityRemainingDays(() -> this.validityDaysRemaining.get());
    }

    private void initTaskScheduler() {
        this.taskScheduler.scheduleAtFixedRate(() -> {
            this.checkCertificateValidity();
            this.setMetrics();
        }, TASK_INTERVAL);
    }

    private void setMetrics() {
        this.validityDaysRemaining.set(this.certificate.getValidityRemainingDays());
    }

    static SignatureCertificateHandling create(byte[] certificateBytes, TaskScheduler taskScheduler, @Nullable SignatureMetricsService signatureMetricsService, String applicationName) {
        SignatureCertificate signatureCertificate = SignatureCertificate.fromBytes(certificateBytes);
        SignatureCertificateHandling certificateHandling = new SignatureCertificateHandling(signatureCertificate, taskScheduler, signatureMetricsService, applicationName);
        certificateHandling.initialCheck();
        certificateHandling.init();
        return certificateHandling;
    }

    @Generated
    public SignatureCertificateHandling(SignatureCertificate certificate, TaskScheduler taskScheduler, SignatureMetricsService signatureMetricsService, String applicationName) {
        this.certificate = certificate;
        this.taskScheduler = taskScheduler;
        this.signatureMetricsService = signatureMetricsService;
        this.applicationName = applicationName;
    }
}

