/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.errorhandling;

import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import java.util.List;
import java.util.regex.Pattern;
import net.logstash.logback.stacktrace.StackElementFilter;
import net.logstash.logback.stacktrace.StackHasher;

public class StackTraceHasher {
    private final StackHasher stackHasher;

    public StackTraceHasher(KafkaProperties kafkaProperties) {
        StackElementFilter filter = StackElementFilter.byPattern(this.toPattern(kafkaProperties.getErrorStackTraceHashExclusionPatterns()));
        this.stackHasher = new StackHasher(filter);
    }

    public String hash(Throwable throwable) {
        if (throwable != null) {
            return this.stackHasher.hexHash(throwable);
        }
        return null;
    }

    private List<Pattern> toPattern(List<String> patternStrings) {
        return patternStrings.stream().map(Pattern::compile).toList();
    }
}

