/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.log;

import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.messaging.model.MessageUser;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArgument;

class MessageLogger
implements StructuredArgument {
    private final Message message;

    static MessageLogger message(Object message) {
        if (message instanceof Message) {
            Message msg = (Message)message;
            return new MessageLogger(msg);
        }
        return new SimpleMessageLogger(message.getClass().getSimpleName());
    }

    public void writeTo(JsonGenerator generator) throws IOException {
        generator.writeStringField("messageType", this.message.getType().getName());
        generator.writeStringField("messageVersion", this.message.getType().getVersion());
        generator.writeStringField("messageId", this.message.getIdentity().getId());
        generator.writeStringField("messageIdempotenceId", this.message.getIdentity().getIdempotenceId());
        generator.writeStringField("messageCreated", this.message.getIdentity().getCreatedZoned().toString());
        generator.writeStringField("messagePublisherSystem", this.message.getPublisher().getSystem());
        generator.writeStringField("messagePublisherService", this.message.getPublisher().getService());
        generator.writeStringField("messageUserId", (String)this.message.getOptionalUser().map(MessageUser::getId).orElse(null));
    }

    public String toString() {
        return String.format("%s (%s)", this.message.getType().getName(), this.message.getIdentity().getId());
    }

    @Generated
    private MessageLogger(Message message) {
        this.message = message;
    }

    private static class SimpleMessageLogger
    extends MessageLogger {
        private final String messageType;

        public SimpleMessageLogger(String messageType) {
            super(null);
            this.messageType = messageType;
        }

        @Override
        public void writeTo(JsonGenerator generator) throws IOException {
            generator.writeStringField("messageType", this.messageType);
        }

        @Override
        public String toString() {
            return this.messageType;
        }
    }
}

