/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.log;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import net.logstash.logback.argument.StructuredArgument;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;

class TopicLogger
implements StructuredArgument {
    @NonNull
    private final String topicName;
    private final Integer partition;

    static TopicLogger topic(ConsumerRecord<?, ?> record) {
        return new TopicLogger(record.topic(), record.partition());
    }

    static TopicLogger topic(ProducerRecord<?, ?> record) {
        return new TopicLogger(record.topic(), record.partition());
    }

    static TopicLogger topic(TopicPartition topicPartition) {
        return new TopicLogger(topicPartition.topic(), topicPartition.partition());
    }

    static TopicLogger topic(RecordMetadata metadata) {
        return new TopicLogger(metadata.topic(), metadata.partition());
    }

    public void writeTo(JsonGenerator generator) throws IOException {
        generator.writeStringField("topic", this.topicName);
        if (this.partition != null) {
            generator.writeNumberField("partition", this.partition.intValue());
        }
    }

    public String toString() {
        if (this.partition != null) {
            return String.format("%s (%s)", this.topicName, this.partition);
        }
        return String.format("%s", this.topicName);
    }

    @Generated
    private TopicLogger(@NonNull String topicName, Integer partition) {
        if (topicName == null) {
            throw new NullPointerException("topicName is marked non-null but is null");
        }
        this.topicName = topicName;
        this.partition = partition;
    }
}

