/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureSubscriberProperties;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class SubscriberValidationPropertiesContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriberValidationPropertiesContainer.class);
    private final SignatureSubscriberProperties signatureSubscriberProperties;
    private Map<String, AllowedPublishers> allowedPublishersByMessageName;

    @PostConstruct
    public void init() {
        this.allowedPublishersByMessageName = this.signatureSubscriberProperties.allowedPublishers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AllowedPublishers((String)entry.getKey(), (List)entry.getValue())));
        log.info("SubscriberValidationPropertiesContainer initialized");
    }

    public boolean isPublisherAllowedForMessage(String messageType, String publisher) {
        AllowedPublishers allowedPublishers = this.allowedPublishersByMessageName.get(messageType);
        if (allowedPublishers == null) {
            return true;
        }
        return allowedPublishers.isAllowedForPublisher(publisher);
    }

    public boolean isSignatureRequired(String messageTypeName) {
        if (!this.isSignatureRequired()) {
            return false;
        }
        return !this.isMessageTypeWhitelisted(messageTypeName);
    }

    public boolean isSignatureRequired() {
        return this.signatureSubscriberProperties.requireSignature();
    }

    private boolean isMessageTypeWhitelisted(String messageType) {
        return this.signatureSubscriberProperties.acceptUnsignedMessagetypeWhitelist().contains(messageType);
    }

    @Generated
    public SubscriberValidationPropertiesContainer(SignatureSubscriberProperties signatureSubscriberProperties) {
        this.signatureSubscriberProperties = signatureSubscriberProperties;
    }

    private record AllowedPublishers(String event, List<String> publishers) {
        public boolean isAllowedForPublisher(String publisher) {
            return this.publishers.contains(publisher);
        }
    }
}

