/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.common.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.common.SignatureCertificate;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureConfigurationException;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.ByteSigner;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignaturePublisherProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureVerifier;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignaturePublisherCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignaturePublisherCheck.class);
    private static final byte[] BYTES_TO_SIGN = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final SignaturePublisherProperties signaturePublisherProperties;
    private final SignatureVerifier signatureVerifier;

    @PostConstruct
    void checkCertificateAndPrivateKeyConsistency() {
        CryptoProviderHelper.installCryptoProvider();
        ByteSigner byteSigner = new ByteSigner(this.signaturePublisherProperties.signatureKey());
        byte[] signature = byteSigner.createSignature(BYTES_TO_SIGN);
        SignatureCertificate certificate = SignatureCertificate.fromBytes(this.signaturePublisherProperties.signatureCertificate());
        boolean verify = this.signatureVerifier.verify(certificate, BYTES_TO_SIGN, signature);
        if (!verify) {
            String message = "The private key provided for signing kafka messages does not match the public key in the certificate for " + certificate.getSubjectDistinguishedName();
            log.error(message);
            throw MessageSignatureConfigurationException.signatureConfigurationFailure(message);
        }
    }

    @Generated
    public SignaturePublisherCheck(SignaturePublisherProperties signaturePublisherProperties, SignatureVerifier signatureVerifier) {
        this.signaturePublisherProperties = signaturePublisherProperties;
        this.signatureVerifier = signatureVerifier;
    }
}

