/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.kafka.signature.common.CertificateHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.common.SignatureCertificate;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateException;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateWithChainValidity;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureSubscriberProperties;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class SubscriberCertificatesContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriberCertificatesContainer.class);
    private final SignatureSubscriberProperties signatureSubscriberProperties;
    private Map<String, CertificateChainEntry> certificateChainsByServiceName;

    @PostConstruct
    public void init() {
        this.certificateChainsByServiceName = this.toRealCertificatesChain(this.signatureSubscriberProperties.certificateChains());
        this.validateCertificates(this.certificateChainsByServiceName);
        log.info("SubscriberCertificatesContainer initialized");
    }

    public SignatureCertificateWithChainValidity getCertificateWithSerialNumber(byte[] certificateSerialNumber) {
        for (CertificateChainEntry certificateChainEntry : this.certificateChainsByServiceName.values()) {
            SignatureCertificateWithChainValidity certificateWithSerialNumber = certificateChainEntry.getCertificateWithSerialNumber(certificateSerialNumber);
            if (certificateWithSerialNumber == null) continue;
            return certificateWithSerialNumber;
        }
        return null;
    }

    boolean areCertificateChainsValid(String serviceName) {
        return this.certificateChainsByServiceName.get(serviceName).chains().stream().allMatch(CertificateChain::isValid);
    }

    private void validateCertificates(Map<String, CertificateChainEntry> certificateChainsByServiceName) {
        log.debug("Validating properties");
        this.validateCertificateChain(certificateChainsByServiceName);
        log.debug("Validating properties done");
    }

    private void validateCertificateChain(Map<String, CertificateChainEntry> certificateChainsByServiceName) {
        log.debug("Validating certificate chain");
        for (CertificateChainEntry certificateChainEntry : certificateChainsByServiceName.values()) {
            this.validateCertificateChain(certificateChainEntry);
        }
        log.debug("Validating certificate chain done");
    }

    private void validateCertificateChain(CertificateChainEntry certificateChainEntry) {
        log.debug("Validating certificate chain for service {}", (Object)certificateChainEntry.service());
        List<CertificateChain> chains = certificateChainEntry.chains();
        for (int i = 0; i < chains.size(); ++i) {
            CertificateChain certificateChain = chains.get(i);
            List<SignatureCertificate> certificates = certificateChain.getCertificates();
            log.debug("Validating certificate chain {} (index {}) for service {} and certificates {}", new Object[]{certificateChain.getName(), i, certificateChainEntry.service(), certificates.stream().map(SignatureCertificate::getSubjectDistinguishedName).collect(Collectors.joining(" -> "))});
            List<X509Certificate> x509Certificates = certificates.stream().map(SignatureCertificate::certificate).collect(Collectors.toList());
            try {
                CertificateHelper.validateCertificateChain(x509Certificates);
                certificateChain.updateValidity(true);
                continue;
            }
            catch (CertificateException e) {
                log.error(String.format("Certificate chain validation failed for service %s and chain %s", certificateChainEntry.service(), certificateChain.getName()), (Throwable)e);
                certificateChain.updateValidity(false);
            }
        }
    }

    private Map<String, CertificateChainEntry> toRealCertificatesChain(Map<String, Map<String, List<String>>> certificateChains) {
        HashMap<String, CertificateChainEntry> result = new HashMap<String, CertificateChainEntry>();
        for (Map.Entry<String, Map<String, List<String>>> certificateChainByName : certificateChains.entrySet()) {
            String serviceName = certificateChainByName.getKey();
            List<CertificateChain> convertedCertificateChainsOfService = this.getConvertedCertificateChain(certificateChainByName, serviceName);
            result.put(serviceName, new CertificateChainEntry(serviceName, convertedCertificateChainsOfService));
        }
        return result;
    }

    private List<CertificateChain> getConvertedCertificateChain(Map.Entry<String, Map<String, List<String>>> certificateChainByName, String serviceName) {
        ArrayList<CertificateChain> realCertificateChainsOfService = new ArrayList<CertificateChain>();
        Map<String, List<String>> certificateChainsOfService = certificateChainByName.getValue();
        for (Map.Entry<String, List<String>> certificateChainOfService : certificateChainsOfService.entrySet()) {
            String chainName = certificateChainOfService.getKey();
            log.debug("Adding certificate chain {} for service {}", (Object)chainName, (Object)serviceName);
            List<SignatureCertificate> convertedCertificateChain = certificateChainOfService.getValue().stream().map(certificateString -> SignatureCertificate.fromBytes(certificateString.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
            CertificateChain certificateChain = new CertificateChain(this, chainName, convertedCertificateChain);
            realCertificateChainsOfService.add(certificateChain);
        }
        return realCertificateChainsOfService;
    }

    @Generated
    public SubscriberCertificatesContainer(SignatureSubscriberProperties signatureSubscriberProperties) {
        this.signatureSubscriberProperties = signatureSubscriberProperties;
    }

    record CertificateChainEntry(String service, List<CertificateChain> chains) {
        SignatureCertificateWithChainValidity getCertificateWithSerialNumber(byte[] certificateSerialNumber) {
            return this.chains.stream().map(certificateChain -> certificateChain.getCertificateWithSerialNumber(certificateSerialNumber)).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }

    private class CertificateChain {
        private final String name;
        private final List<SignatureCertificate> certificates;
        private boolean valid = false;

        SignatureCertificateWithChainValidity getCertificateWithSerialNumber(byte[] certificateSerialNumber) {
            SignatureCertificate leafCertificate = this.certificates.getFirst();
            if (Objects.deepEquals(leafCertificate.getSerialNumber(), certificateSerialNumber)) {
                return new SignatureCertificateWithChainValidity(leafCertificate, this.valid);
            }
            return null;
        }

        public void updateValidity(boolean valid) {
            this.valid = valid;
        }

        @Generated
        public CertificateChain(SubscriberCertificatesContainer subscriberCertificatesContainer, String name, List<SignatureCertificate> certificates) {
            this.name = name;
            this.certificates = certificates;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<SignatureCertificate> getCertificates() {
            return this.certificates;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }
    }
}

