/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.contract;

import ch.admin.bit.jeap.messaging.kafka.contract.ContractMetric;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsValidator;
import ch.admin.bit.jeap.messaging.kafka.contract.DefaultContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.contract.DefaultContractsValidator;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={ContractMetricConfiguration.class})
public class ContractConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ContractsProvider.class})
    public ContractsProvider defaultContractsProvider() {
        return new DefaultContractsProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={ContractsValidator.class})
    public ContractsValidator defaultContractsValidator(@Value(value="${spring.application.name}") String appName, ContractsProvider contractsProvider) {
        return new DefaultContractsValidator(appName, contractsProvider);
    }

    @Configuration
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public static class ContractMetricConfiguration {
        @Bean
        public ContractMetric contractMetric(MeterRegistry meterRegistry, KafkaProperties kafkaProperties, ContractsProvider contractsProvider) {
            return new ContractMetric(meterRegistry, kafkaProperties, contractsProvider);
        }
    }
}

