/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.contract;

import ch.admin.bit.jeap.messaging.contract.v2.Contract;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContractMetric.class);
    private static final String METRIC_NAME = "jeap.messaging.contract";
    private static final String TAG_SWITCH_NAME = "switch";
    private final MeterRegistry meterRegistry;
    private final KafkaProperties kafkaProperties;
    private final ContractsProvider contractsProvider;

    @PostConstruct
    private void initialize() {
        int consumeWithoutContract = this.kafkaProperties.isConsumeWithoutContractAllowed() ? 1 : 0;
        int publishWithoutContract = this.kafkaProperties.isPublishWithoutContractAllowed() ? 1 : 0;
        int noMasterContracts = this.hasNoMasterContracts() ? 1 : 0;
        List<MultiGauge.Row> rows = List.of(MultiGauge.Row.of((Tags)Tags.of((String)TAG_SWITCH_NAME, (String)"consumeWithoutContract"), (Number)consumeWithoutContract), MultiGauge.Row.of((Tags)Tags.of((String)TAG_SWITCH_NAME, (String)"publishWithoutContract"), (Number)publishWithoutContract), MultiGauge.Row.of((Tags)Tags.of((String)TAG_SWITCH_NAME, (String)"noMasterContracts"), (Number)noMasterContracts));
        MultiGauge.builder((String)METRIC_NAME).description("Contract validation of jeap-messaging library").register(this.meterRegistry).register(rows);
    }

    private boolean hasNoMasterContracts() {
        return !this.getContractBranches().stream().map(b -> b == null ? "none" : b).map(String::toLowerCase).allMatch("master"::equals);
    }

    private Set<String> getContractBranches() {
        return this.contractsProvider.getContracts().stream().map(Contract::getRegistryBranch).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Generated
    public ContractMetric(MeterRegistry meterRegistry, KafkaProperties kafkaProperties, ContractsProvider contractsProvider) {
        this.meterRegistry = meterRegistry;
        this.kafkaProperties = kafkaProperties;
        this.contractsProvider = contractsProvider;
    }
}

