/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.spring;

import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProvider;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import lombok.Generated;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AbstractSchemaRegistryBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    protected Environment environment;
    protected BeanFactory beanFactory;
    protected KafkaProperties kafkaProperties;
    private JeapKafkaBeanNames beanNames;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.kafkaProperties = JeapKafkaPropertyFactory.createJeapKafkaProperties(this.environment);
        this.beanNames = new JeapKafkaBeanNames(this.kafkaProperties.getDefaultClusterName());
        this.kafkaProperties.clusterNames().forEach(clusterName -> {
            ClusterProperties clusterProperties = this.kafkaProperties.clusterProperties((String)clusterName).orElseThrow();
            if (this.shouldRegisterSchemaRegistryBeansForCluster(clusterProperties)) {
                this.registerKafkaAvroSerdeProviderBeanForCluster(registry, (String)clusterName);
            }
        });
    }

    protected abstract boolean shouldRegisterSchemaRegistryBeansForCluster(ClusterProperties var1);

    private void registerKafkaAvroSerdeProviderBeanForCluster(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getKafkaAvroSerdeProviderBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.createKafkaAvroSerdeProviderBeanDefinition(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private GenericBeanDefinition createKafkaAvroSerdeProviderBeanDefinition(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(KafkaAvroSerdeProvider.class);
        beanDefinition.setInstanceSupplier(() -> {
            ObjectProvider cryptoConfig = this.beanFactory.getBeanProvider(JeapKafkaAvroSerdeCryptoConfig.class);
            return this.createKafkaAvroSerializerProvider(clusterName, (JeapKafkaAvroSerdeCryptoConfig)cryptoConfig.getIfAvailable());
        });
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.beanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    protected abstract KafkaAvroSerdeProvider createKafkaAvroSerializerProvider(String var1, JeapKafkaAvroSerdeCryptoConfig var2);

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

