/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.publisher;

import ch.admin.bit.jeap.messaging.kafka.signature.publisher.ByteSigner;
import org.apache.kafka.common.header.Headers;

class SignatureInjector {
    private final ByteSigner byteSigner;
    private final byte[] certificateSerialNumber;

    SignatureInjector(ByteSigner byteSigner, byte[] certificateSerialNumber) {
        this.byteSigner = byteSigner;
        this.certificateSerialNumber = certificateSerialNumber;
    }

    void injectSignature(Headers headers, byte[] bytesToSign, boolean isKey) {
        byte[] signature = this.byteSigner.createSignature(bytesToSign);
        headers.add(this.determineHeaderKey(isKey), signature);
        if (!isKey) {
            headers.add("jeap-cert", this.certificateSerialNumber);
        }
    }

    private String determineHeaderKey(boolean isKey) {
        return isKey ? "jeap-sign-key" : "jeap-sign";
    }
}

