/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.publisher;

import ch.admin.bit.jeap.messaging.kafka.signature.common.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureException;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.PrivateKeyFactory;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSigner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByteSigner.class);
    private final PrivateKey privateKey;

    public ByteSigner(byte[] privateKeyBytes) {
        this(PrivateKeyFactory.createPrivateKey(privateKeyBytes));
    }

    ByteSigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] createSignature(byte[] bytes) {
        try {
            Signature signature = this.createSignature();
            signature.update(bytes);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw MessageSignatureException.signatureCreationFailed(e);
        }
    }

    private Signature createSignature() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature signature = CryptoProviderHelper.getSignatureInstance();
        signature.initSign(this.privateKey);
        return signature;
    }
}

