/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.kafka.signature.common.CertificateHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateValidationException;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateValidator;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateWithChainValidity;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureVerifier;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberCertificatesContainer;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CertificateAndSignatureVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateAndSignatureVerifier.class);
    private final SubscriberCertificatesContainer subscriberCertificatesContainer;
    private final SignatureCertificateValidator certificateValidator;
    private final SignatureVerifier signatureVerifier;

    public boolean verify(byte[] bytesToValidate, byte[] signature, byte[] certificateSerialNumber) {
        return this.doVerify(null, bytesToValidate, signature, certificateSerialNumber);
    }

    public boolean verify(String serviceName, byte[] bytesToValidate, byte[] signature, byte[] certificateSerialNumber) {
        return this.doVerify(serviceName, bytesToValidate, signature, certificateSerialNumber);
    }

    private boolean doVerify(String serviceName, byte[] bytesToValidate, byte[] signature, byte[] certificateSerialNumber) {
        SignatureCertificateWithChainValidity certificateWithChainValidity = this.subscriberCertificatesContainer.getCertificateWithSerialNumber(certificateSerialNumber);
        if (certificateWithChainValidity == null) {
            throw CertificateValidationException.certificateNotFound(certificateSerialNumber);
        }
        this.certificateValidator.validate(certificateWithChainValidity);
        String commonName = CertificateHelper.getCommonName(certificateWithChainValidity.getSubjectDistinguishedName());
        if (serviceName != null && !Objects.equals(serviceName, commonName)) {
            log.error("Service name {} does not match CN of certificate {}", (Object)serviceName, (Object)commonName);
            throw CertificateValidationException.certificateCommonNameNotValid(serviceName, commonName);
        }
        return this.signatureVerifier.verify(certificateWithChainValidity.certificate(), bytesToValidate, signature);
    }

    @Generated
    public CertificateAndSignatureVerifier(SubscriberCertificatesContainer subscriberCertificatesContainer, SignatureCertificateValidator certificateValidator, SignatureVerifier signatureVerifier) {
        this.subscriberCertificatesContainer = subscriberCertificatesContainer;
        this.certificateValidator = certificateValidator;
        this.signatureVerifier = signatureVerifier;
    }
}

