/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.properties.cluster;

import java.net.URI;
import lombok.Generated;

public class GlueProperties {
    String registryName;
    String region;
    String assumeIamRoleArn;
    URI stsEndpoint = null;
    int stsClientTimeoutSeconds = 30;
    URI endpoint;

    public void validateProperties(boolean isConfluentRegistryActive) {
        if (!this.isActive()) {
            return;
        }
        if (isConfluentRegistryActive) {
            throw new IllegalArgumentException("Confluent schema registry and Glue schema registry cannot be active at the same time for a kafka cluster configuration. Please configure either jeap.messaging.kafka.cluster.<name>.aws.registryName OR jeap.messaging.kafka.cluster.<name>.schemaRegistryUrl");
        }
        if (this.region == null || this.region.isBlank()) {
            throw new IllegalArgumentException("Property %s.cluster.<name>.aws.glue.region cannot be blank - please provide a value".formatted("jeap.messaging.kafka"));
        }
    }

    public boolean isActive() {
        return this.registryName != null;
    }

    public boolean useAssumeRoleForAuth() {
        return this.assumeIamRoleArn != null;
    }

    @Generated
    public GlueProperties() {
    }

    @Generated
    public String getRegistryName() {
        return this.registryName;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getAssumeIamRoleArn() {
        return this.assumeIamRoleArn;
    }

    @Generated
    public URI getStsEndpoint() {
        return this.stsEndpoint;
    }

    @Generated
    public int getStsClientTimeoutSeconds() {
        return this.stsClientTimeoutSeconds;
    }

    @Generated
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setAssumeIamRoleArn(String assumeIamRoleArn) {
        this.assumeIamRoleArn = assumeIamRoleArn;
    }

    @Generated
    public void setStsEndpoint(URI stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
    }

    @Generated
    public void setStsClientTimeoutSeconds(int stsClientTimeoutSeconds) {
        this.stsClientTimeoutSeconds = stsClientTimeoutSeconds;
    }

    @Generated
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlueProperties)) {
            return false;
        }
        GlueProperties other = (GlueProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStsClientTimeoutSeconds() != other.getStsClientTimeoutSeconds()) {
            return false;
        }
        String this$registryName = this.getRegistryName();
        String other$registryName = other.getRegistryName();
        if (this$registryName == null ? other$registryName != null : !this$registryName.equals(other$registryName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$assumeIamRoleArn = this.getAssumeIamRoleArn();
        String other$assumeIamRoleArn = other.getAssumeIamRoleArn();
        if (this$assumeIamRoleArn == null ? other$assumeIamRoleArn != null : !this$assumeIamRoleArn.equals(other$assumeIamRoleArn)) {
            return false;
        }
        URI this$stsEndpoint = this.getStsEndpoint();
        URI other$stsEndpoint = other.getStsEndpoint();
        if (this$stsEndpoint == null ? other$stsEndpoint != null : !((Object)this$stsEndpoint).equals(other$stsEndpoint)) {
            return false;
        }
        URI this$endpoint = this.getEndpoint();
        URI other$endpoint = other.getEndpoint();
        return !(this$endpoint == null ? other$endpoint != null : !((Object)this$endpoint).equals(other$endpoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlueProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStsClientTimeoutSeconds();
        String $registryName = this.getRegistryName();
        result = result * 59 + ($registryName == null ? 43 : $registryName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $assumeIamRoleArn = this.getAssumeIamRoleArn();
        result = result * 59 + ($assumeIamRoleArn == null ? 43 : $assumeIamRoleArn.hashCode());
        URI $stsEndpoint = this.getStsEndpoint();
        result = result * 59 + ($stsEndpoint == null ? 43 : ((Object)$stsEndpoint).hashCode());
        URI $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : ((Object)$endpoint).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GlueProperties(registryName=" + this.getRegistryName() + ", region=" + this.getRegion() + ", assumeIamRoleArn=" + this.getAssumeIamRoleArn() + ", stsEndpoint=" + String.valueOf(this.getStsEndpoint()) + ", stsClientTimeoutSeconds=" + this.getStsClientTimeoutSeconds() + ", endpoint=" + String.valueOf(this.getEndpoint()) + ")";
    }
}

