/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth;

import ch.admin.bit.jeap.messaging.kafka.auth.KafkaAuthProperties;
import ch.admin.bit.jeap.messaging.kafka.auth.KafkaTrustStoreUtility;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.PropertyRequirements;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.SslProperties;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSslAuthProperties
implements KafkaAuthProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaSslAuthProperties.class);
    private final KafkaProperties kafkaProperties;

    @Override
    public Map<String, Object> authenticationProperties(String clusterName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("security.protocol", PropertyRequirements.requireNonNullValue((String)"Security Protocol", this.kafkaProperties.getSecurityProtocol((String)clusterName)).name);
        KafkaTrustStoreUtility.setTrustStorePropertiesFromSystemProperties(props, false, false);
        SslProperties sslProperties = this.kafkaProperties.getSslProperties(clusterName);
        this.validateSslProperties(sslProperties);
        this.setKeyStorePropertiesFromSslProperties(props, sslProperties);
        KafkaTrustStoreUtility.setTrustStorePropertiesFromSslProperties(props, sslProperties);
        return props;
    }

    private void validateSslProperties(SslProperties sslProperties) {
        PropertyRequirements.requireNonNullValue("sslProperties", sslProperties);
        if (sslProperties.getKeyStoreLocation() == null || sslProperties.getKeyPassword() == null) {
            throw new IllegalStateException("When configuring kafka with ssl, the keyStoreLocation and the keyPassword must be set using jeap.kafka.messaging.cluster.<name>.keyStoreLocation and jeap.kafka.messaging.cluster.<name>.keyPassword.");
        }
    }

    private void setKeyStorePropertiesFromSslProperties(Map<String, Object> props, SslProperties sslProperties) {
        props.put("ssl.keystore.location", sslProperties.getKeyStoreLocation());
        props.put("ssl.key.password", sslProperties.getKeyPassword());
        if (sslProperties.getKeyStoreType() != null) {
            props.put("ssl.keystore.type", sslProperties.getKeyStoreType());
        }
    }

    @Generated
    public KafkaSslAuthProperties(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }
}

