/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth;

import ch.admin.bit.jeap.messaging.kafka.auth.KafkaAuthProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AbstractAuthBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthBeanRegistrar.class);
    private final Class<? extends KafkaAuthProperties> authPropertiesType;
    protected Environment environment;
    protected BeanFactory beanFactory;
    protected KafkaProperties kafkaProperties;
    private JeapKafkaBeanNames jeapKafkaBeanNames;

    public AbstractAuthBeanRegistrar(Class<? extends KafkaAuthProperties> authPropertiesType) {
        this.authPropertiesType = authPropertiesType;
    }

    protected abstract boolean shouldRegisterKafkaAuthPropertiesBeanForCluster(ClusterProperties var1);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.kafkaProperties = JeapKafkaPropertyFactory.createJeapKafkaProperties(this.environment);
        this.jeapKafkaBeanNames = new JeapKafkaBeanNames(this.kafkaProperties.getDefaultClusterName());
        this.kafkaProperties.clusterNames().forEach(clusterName -> {
            ClusterProperties clusterProperties = this.kafkaProperties.clusterProperties((String)clusterName).orElseThrow();
            if (this.shouldRegisterKafkaAuthPropertiesBeanForCluster(clusterProperties)) {
                this.registerKafkaAuthPropertiesBeanForCluster(registry, (String)clusterName);
            }
        });
    }

    private void registerKafkaAuthPropertiesBeanForCluster(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.jeapKafkaBeanNames.getAuthPropertiesBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.createKafkaAuthPropertiesBeanForCluster(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private GenericBeanDefinition createKafkaAuthPropertiesBeanForCluster(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(this.authPropertiesType);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.jeapKafkaBeanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

