/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerExceptionInformation;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureAuthenticityService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.common.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureValidationException;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.SignatureAuthenticityMessageException;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.CertificateAndSignatureVerifier;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberValidationPropertiesContainer;
import ch.admin.bit.jeap.messaging.model.Message;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignatureAuthenticityService
implements SignatureAuthenticityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSignatureAuthenticityService.class);
    private final SubscriberValidationPropertiesContainer validationPropertiesContainer;
    private final CertificateAndSignatureVerifier certificateAndSignatureVerifier;
    private final SignatureMetricsService signatureMetricsService;
    private AtomicLong signatureRequiredState;

    public DefaultSignatureAuthenticityService(SubscriberValidationPropertiesContainer validationPropertiesContainer, CertificateAndSignatureVerifier certificateAndSignatureVerifier, Optional<SignatureMetricsService> signatureMetricsService) {
        this.validationPropertiesContainer = validationPropertiesContainer;
        this.certificateAndSignatureVerifier = certificateAndSignatureVerifier;
        this.signatureMetricsService = signatureMetricsService.orElse(null);
        log.info("SignatureAuthenticityService initialized, requireSignature (strict mode): {}", (Object)validationPropertiesContainer.isSignatureRequired());
    }

    @PostConstruct
    void init() {
        CryptoProviderHelper.installCryptoProvider();
        this.initMetrics();
    }

    @Override
    public void checkAuthenticityValue(Object deserialized, Headers headers, byte[] bytesToValidate) {
        if (deserialized instanceof Message) {
            Message message = (Message)deserialized;
            if (headers == null) {
                throw MessageSignatureValidationException.headersMissing(true);
            }
            String messageTypeName = message.getType().getName();
            try {
                this.doCheckAuthenticityValue(message, headers, bytesToValidate);
                this.recordSignatureValidation(messageTypeName, true);
            }
            catch (Exception exception) {
                this.recordSignatureValidation(messageTypeName, false);
                if (exception instanceof MessageHandlerExceptionInformation) {
                    MessageHandlerExceptionInformation messageHandlerExceptionInformation = (MessageHandlerExceptionInformation)exception;
                    throw SignatureAuthenticityMessageException.fromMessageHandlerExceptionInformation(message, messageHandlerExceptionInformation, exception);
                }
                throw exception;
            }
        } else {
            throw MessageSignatureValidationException.notAllowedMessageType(deserialized);
        }
    }

    @Override
    public void checkAuthenticityKey(Headers headers, byte[] bytesToValidate) {
        boolean result;
        if (headers == null) {
            throw MessageSignatureValidationException.headersMissing(true);
        }
        Header certificateHeader = headers.lastHeader("jeap-cert");
        Header signatureHeader = headers.lastHeader("jeap-sign-key");
        boolean signatureRequired = false;
        this.validateHeaders(signatureRequired, signatureHeader, certificateHeader, "unknown", "unknown");
        if (certificateHeader != null && !(result = this.certificateAndSignatureVerifier.verify(bytesToValidate, signatureHeader.value(), certificateHeader.value()))) {
            throw MessageSignatureValidationException.invalidSignatureKey();
        }
    }

    private void doCheckAuthenticityValue(Message message, Headers headers, byte[] bytesToValidate) {
        boolean result;
        String service;
        String messageTypeName = message.getType().getName();
        if (!this.validationPropertiesContainer.isPublisherAllowedForMessage(messageTypeName, service = message.getPublisher().getService())) {
            throw MessageSignatureValidationException.publisherNotAllowed(messageTypeName, service);
        }
        Header certificateHeader = headers.lastHeader("jeap-cert");
        Header signatureHeader = headers.lastHeader("jeap-sign");
        boolean signatureRequired = this.validationPropertiesContainer.isSignatureRequired(messageTypeName);
        this.validateHeaders(signatureRequired, signatureHeader, certificateHeader, messageTypeName, service);
        if (certificateHeader != null && !(result = this.certificateAndSignatureVerifier.verify(service, bytesToValidate, signatureHeader.value(), certificateHeader.value()))) {
            throw MessageSignatureValidationException.invalidSignatureValue(messageTypeName, service);
        }
    }

    private void validateHeaders(boolean signatureRequired, Header signatureHeader, Header certificateHeader, String messageTypeName, String service) {
        if (signatureRequired) {
            if (signatureHeader == null || certificateHeader == null) {
                throw MessageSignatureValidationException.strictModeSignatureHeadersMissing(messageTypeName, service);
            }
        } else {
            if (signatureHeader == null && certificateHeader != null) {
                throw MessageSignatureValidationException.signatureHeaderMissing(messageTypeName, service);
            }
            if (signatureHeader != null && certificateHeader == null) {
                throw MessageSignatureValidationException.certificateHeaderMissing(messageTypeName, service);
            }
        }
    }

    private void recordSignatureValidation(String keyMessageTypeMetricName, boolean result) {
        if (this.signatureMetricsService != null) {
            this.signatureMetricsService.recordSignatureValidation(keyMessageTypeMetricName, result);
        }
    }

    private void initMetrics() {
        this.signatureRequiredState = new AtomicLong(this.validationPropertiesContainer.isSignatureRequired() ? 1L : 0L);
        if (this.signatureMetricsService != null) {
            this.signatureMetricsService.initSignatureRequiredMetricName(() -> this.signatureRequiredState.get());
        }
    }
}

