/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.spring;

import java.util.Objects;

public class JeapKafkaBeanNames {
    private final String defaultClusterName;

    public JeapKafkaBeanNames(String defaultClusterName) {
        this.defaultClusterName = Objects.requireNonNull(defaultClusterName, "defaultClusterName");
    }

    public boolean isPrimaryBean(String clusterName) {
        return this.defaultClusterName.equals(clusterName);
    }

    public String getListenerContainerFactoryBeanName(String clusterName) {
        return this.getBeanName(clusterName, "ListenerContainerFactory");
    }

    public String getAdminBeanName(String clusterName) {
        return this.getBeanName(clusterName, "Admin");
    }

    public String getConsumerFactoryBeanName(String clusterName) {
        return this.getBeanName(clusterName, "ConsumerFactory");
    }

    public String getTransactionManagerBeanName(String clusterName) {
        return this.getBeanName(clusterName, "TransactionManager");
    }

    public String getProducerFactoryBeanName(String clusterName) {
        return this.getBeanName(clusterName, "ProducerFactory");
    }

    public String getKafkaTemplateBeanName(String clusterName) {
        return this.getBeanName(clusterName, "Template");
    }

    public String getKafkaAvroSerdeProviderBeanName(String clusterName) {
        return this.getBeanName(clusterName, "AvroSerdeProvider");
    }

    public String getAuthPropertiesBeanName(String clusterName) {
        return this.getBeanName(clusterName, "AuthProperties");
    }

    public String getBeanName(String clusterName, String beanType) {
        boolean isPrimaryBean = clusterName == null || this.isPrimaryBean(clusterName);
        Object prefix = isPrimaryBean ? "kafka" : clusterName + "Kafka";
        return (String)prefix + beanType;
    }

    public boolean isPrimaryProducerCluster(String defaultProducerClusterOverride, String clusterName) {
        if (defaultProducerClusterOverride != null) {
            return defaultProducerClusterOverride.equals(clusterName);
        }
        return this.isPrimaryBean(clusterName);
    }
}

