/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.contract;

import ch.admin.bit.jeap.messaging.contract.v2.Contract;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.contract.NoContractException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DefaultContractsProvider
implements ContractsProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultContractsProvider.class);
    private static final String CONTRACT_RESOURCES_LOCATION = "classpath*:/ch/admin/bit/jeap/messaging/contracts/";
    private static final String CONTRACT_RESOURCES_LOCATION_PATTERN = "classpath*:/ch/admin/bit/jeap/messaging/contracts/*-contract.json";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final List<Contract> contracts = DefaultContractsProvider.readContracts();

    public DefaultContractsProvider() {
        this.logContracts();
    }

    private void logContracts() {
        if (!this.contracts.isEmpty()) {
            log.debug("Found the following contracts: {}.", (Object)this.contracts.stream().map(this::toContractDescription).collect(Collectors.joining(", ")));
        } else {
            log.debug("No contracts present.");
        }
    }

    private String toContractDescription(Contract contract) {
        return String.format("%s-%s(role=%s, topics=%s, system=%s, app=%s)", contract.getMessageTypeName(), contract.getMessageTypeVersion(), contract.getRole(), this.toTopics(contract.getTopics()), contract.getSystemName(), contract.getAppName());
    }

    private String toTopics(String[] topics) {
        if (topics == null) {
            return "[]";
        }
        return "[" + String.join((CharSequence)", ", topics) + "]";
    }

    @Override
    public List<Contract> getContracts() {
        return this.contracts;
    }

    private static List<Contract> readContracts() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] contractResources = resolver.getResources(CONTRACT_RESOURCES_LOCATION_PATTERN);
            log.debug("Number of contract resources found: {}.", (Object)contractResources.length);
            return Arrays.stream(contractResources).map(DefaultContractsProvider::readContract).toList();
        }
        catch (FileNotFoundException fnfe) {
            log.debug("Resource location '{}' for contracts not found, no v2 contracts loaded.", (Object)CONTRACT_RESOURCES_LOCATION);
            return Collections.emptyList();
        }
        catch (IOException ioe) {
            log.error("Loading contracts failed.", (Throwable)ioe);
            throw NoContractException.cannotReadContracts(CONTRACT_RESOURCES_LOCATION, ioe);
        }
    }

    private static Contract readContract(Resource contractResource) {
        Contract contract;
        block8: {
            InputStream contractResourceStream = contractResource.getInputStream();
            try {
                contract = (Contract)OBJECT_MAPPER.readValue(contractResourceStream, Contract.class);
                if (contractResourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (contractResourceStream != null) {
                        try {
                            contractResourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw NoContractException.cannotReadContractFile(contractResource, ioe);
                }
            }
            contractResourceStream.close();
        }
        return contract;
    }
}

