/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.properties;

import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.kafka.listener.ListenerContainerRegistry;

public class KafkaConsumerPropertiesValidator
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerPropertiesValidator.class);
    private final ListenerContainerRegistry registry;
    private final KafkaProperties kafkaProperties;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        int listenerContainerCount = this.registry.getListenerContainerIds().size();
        if (listenerContainerCount > 0) {
            log.info("{} kafka listener containers registered - validating consumer properties", (Object)listenerContainerCount);
            this.validatePropertyHasValue("systemName", this.kafkaProperties.getSystemName());
            this.validatePropertyHasValue("serviceName", this.kafkaProperties.getServiceName());
            this.kafkaProperties.clusterNames().forEach(clusterName -> this.validatePropertyHasValue("errorTopicName", this.kafkaProperties.getErrorTopicName((String)clusterName)));
        } else {
            log.debug("No listener containers registered - skipping consumer property validation");
        }
    }

    private void validatePropertyHasValue(String propertyName, String value) {
        if (value == null || value.isBlank()) {
            throw new IllegalStateException("Property jeap.messaging.kafka." + propertyName + " is missing a valid value. This property needs to be set for applications consuming kafka records.");
        }
    }

    @Generated
    public KafkaConsumerPropertiesValidator(ListenerContainerRegistry registry, KafkaProperties kafkaProperties) {
        this.registry = registry;
        this.kafkaProperties = kafkaProperties;
    }
}

