/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth;

import ch.admin.bit.jeap.messaging.kafka.auth.KafkaAuthProperties;
import ch.admin.bit.jeap.messaging.kafka.auth.KafkaTrustStoreUtility;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.PropertyRequirements;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSaslAuthProperties
implements KafkaAuthProperties {
    private final KafkaProperties kafkaProperties;

    public KafkaSaslAuthProperties(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }

    @Override
    public Map<String, Object> authenticationProperties(String clusterName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("security.protocol", PropertyRequirements.requireNonNullValue((String)"Security Protocol", this.kafkaProperties.getSecurityProtocol((String)clusterName)).name);
        if (SecurityProtocol.SASL_SSL.equals((Object)this.kafkaProperties.getSecurityProtocol(clusterName))) {
            KafkaTrustStoreUtility.setTrustStorePropertiesFromSystemProperties(props, false, false);
            if (this.kafkaProperties.getSslProperties(clusterName) != null) {
                KafkaTrustStoreUtility.setTrustStorePropertiesFromSslProperties(props, this.kafkaProperties.getSslProperties(clusterName));
            }
        }
        if (SecurityProtocol.SASL_PLAINTEXT.equals((Object)this.kafkaProperties.getSecurityProtocol(clusterName)) || SecurityProtocol.SASL_SSL.equals((Object)this.kafkaProperties.getSecurityProtocol(clusterName))) {
            props.put("sasl.mechanism", "SCRAM-SHA-512");
            props.put("sasl.jaas.config", this.createSaslJaasConfig(clusterName));
        }
        return props;
    }

    private String createSaslJaasConfig(String clusterName) {
        return String.format("%s required username=\"%s\" password=\"%s\";", "org.apache.kafka.common.security.scram.ScramLoginModule", PropertyRequirements.requireNonNullValue("SASL username", this.kafkaProperties.getUsername(clusterName)), PropertyRequirements.requireNonNullValue("SASL password", this.kafkaProperties.getPassword(clusterName)));
    }
}

