/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.publisher;

import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureConfigurationException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.Nullable;

@ConfigurationProperties(prefix="jeap.messaging.authentication.publisher")
public class SignaturePublisherProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignaturePublisherProperties.class);
    private final byte[] signatureKey;
    private final byte[] signatureCertificate;

    public SignaturePublisherProperties(@Nullable String signatureKey, @Nullable String signatureCertificate) {
        this.signatureKey = signatureKey == null ? null : signatureKey.getBytes(StandardCharsets.UTF_8);
        this.signatureCertificate = signatureCertificate == null ? null : signatureCertificate.getBytes(StandardCharsets.UTF_8);
        log.info("Signing enabled: {}", (Object)this.isSigningEnabled());
    }

    public final boolean isSigningEnabled() {
        return this.signatureKey != null && this.signatureCertificate != null;
    }

    public byte[] signatureKey() {
        return this.signatureKey;
    }

    public byte[] signatureCertificate() {
        return this.signatureCertificate;
    }

    void checkAndLogSigningDisabled() {
        if (this.signatureKey == null && this.signatureCertificate != null) {
            log.error("No signature key provided, but a certificate is provided. Please provide a key to sign messages");
            throw MessageSignatureConfigurationException.signatureConfigurationFailure("No signature key provided, but a certificate is provided. Please provide a key to sign messages");
        }
        if (this.signatureCertificate == null && this.signatureKey != null) {
            log.error("No certificate provided, but a key is provided. Please provide a certificate to sign messages");
            throw MessageSignatureConfigurationException.signatureConfigurationFailure("No certificate provided, but a key is provided. Please provide a certificate to sign messages");
        }
        log.debug("Signing messages is disabled");
    }
}

