/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.properties;

import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.SslProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="jeap.messaging.kafka")
public class KafkaProperties
implements InitializingBean {
    public static final String PREFIX = "jeap.messaging.kafka";
    public static final String DEFAULT_CLUSTER = "default";
    static final List<String> DEFAULT_STACK_TRACE_EXCLUSION_PATTERNS = List.of("^java.base/.*", "^org.springframework.aop..*", ".*\\$\\$FastClassByCGLIB\\$\\$.*", ".*\\$\\$EnhancerBySpringCGLIB\\$\\$.*", ".*\\$\\$EnhancerByCGLIB\\$\\$.*", ".*\\$\\$SpringCGLIB\\$\\$.*");
    private Map<String, ClusterProperties> cluster = new LinkedHashMap<String, ClusterProperties>();
    private String defaultClusterName;
    private String defaultProducerClusterOverride;
    private String bootstrapServers;
    private String consumerBootstrapServers;
    private String producerBootstrapServers;
    private String adminClientBootstrapServers;
    private SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
    private String username;
    private String password;
    private String schemaRegistryUrl;
    private String schemaRegistryUsername;
    private String schemaRegistryPassword;
    private String errorTopicName;
    private boolean autoRegisterSchema = true;
    private boolean useSchemaRegistry = true;
    private boolean exposeMessageKeyToConsumer = false;
    private String systemName;
    private String serviceName;
    private boolean publishWithoutContractAllowed = false;
    private boolean consumeWithoutContractAllowed = false;
    private boolean silentIgnoreWithoutContract = false;
    private long errorServiceRetryIntervalMs = 5000L;
    private long errorServiceRetryAttempts = 5L;
    private int errorEventStackTraceMaxLength = 7000;
    private boolean errorStackTraceHashEnabled = true;
    private List<String> errorStackTraceHashDefaultExclusionPatterns = DEFAULT_STACK_TRACE_EXCLUSION_PATTERNS;
    private List<String> errorStackTraceHashAdditionalExclusionPatterns = List.of();
    private boolean messageTypeEncryptionDisabled = false;

    public void afterPropertiesSet() {
        boolean confluentSchemaRegistryActive;
        boolean mockRegistryActivated = !this.useSchemaRegistry;
        boolean bl = confluentSchemaRegistryActive = mockRegistryActivated || StringUtils.hasText((String)this.schemaRegistryUrl);
        if (this.cluster.isEmpty()) {
            ClusterProperties props = this.createDefaultClusterProperties();
            props.validateProperties(confluentSchemaRegistryActive);
            this.defaultClusterName = DEFAULT_CLUSTER;
        } else {
            this.defaultClusterName = this.validateAndMarkDefaultCluster();
            this.cluster.values().forEach(clusterProperties -> clusterProperties.validateProperties(confluentSchemaRegistryActive));
            this.defaultProducerClusterOverride = this.cluster.entrySet().stream().filter(entry -> ((ClusterProperties)entry.getValue()).isDefaultProducerClusterOverride()).map(Map.Entry::getKey).findFirst().orElse(null);
        }
    }

    public boolean hasDefaultProducerClusterOverride() {
        return this.defaultProducerClusterOverride != null;
    }

    public String getDefaultProducerClusterName() {
        if (this.hasDefaultProducerClusterOverride()) {
            return this.defaultProducerClusterOverride;
        }
        return this.defaultClusterName;
    }

    private String validateAndMarkDefaultCluster() {
        long defaultClusterCount = this.cluster.values().stream().filter(ClusterProperties::isDefaultCluster).count();
        if (defaultClusterCount == 0L) {
            String firstCluster = this.cluster.keySet().iterator().next();
            this.cluster.get(firstCluster).setDefaultCluster(true);
        } else if (defaultClusterCount > 1L) {
            throw new IllegalStateException("When configuring kafka cluster(s), only one cluster can be marked as the default cluster using jeap.kafka.messaging.cluster.<name>.default-cluster=true.");
        }
        long defaultProducerClusterOverrideCount = this.cluster.values().stream().filter(ClusterProperties::isDefaultProducerClusterOverride).count();
        if (defaultProducerClusterOverrideCount > 1L) {
            throw new IllegalStateException("When configuring kafka cluster(s), at most one cluster can be marked as the default producer cluster using jeap.kafka.messaging.cluster.<name>.default-producer-cluster-override=true.");
        }
        return this.cluster.entrySet().stream().filter(e -> ((ClusterProperties)e.getValue()).isDefaultCluster()).map(Map.Entry::getKey).findFirst().orElseThrow();
    }

    private ClusterProperties createDefaultClusterProperties() {
        ClusterProperties props = new ClusterProperties();
        props.setDefaultCluster(true);
        props.setBootstrapServers(this.bootstrapServers);
        props.setAdminClientBootstrapServers(this.adminClientBootstrapServers);
        props.setConsumerBootstrapServers(this.consumerBootstrapServers);
        props.setProducerBootstrapServers(this.producerBootstrapServers);
        props.setSecurityProtocol(this.securityProtocol);
        props.setUsername(this.username);
        props.setPassword(this.password);
        props.setSchemaRegistryPassword(this.schemaRegistryPassword);
        props.setSchemaRegistryUrl(this.schemaRegistryUrl);
        props.setSchemaRegistryUsername(this.schemaRegistryUsername);
        props.setErrorTopicName(this.errorTopicName);
        return props;
    }

    public Optional<ClusterProperties> clusterProperties(String clusterName) {
        if (this.cluster.isEmpty()) {
            return Optional.of(this.createDefaultClusterProperties());
        }
        return Optional.ofNullable(this.cluster.get(clusterName));
    }

    public Set<String> clusterNames() {
        if (this.cluster.isEmpty()) {
            return Set.of(DEFAULT_CLUSTER);
        }
        return Set.copyOf(this.cluster.keySet());
    }

    public String getErrorTopicName(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getErrorTopicName).filter(StringUtils::hasText).orElse(this.errorTopicName);
    }

    public SecurityProtocol getSecurityProtocol(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getSecurityProtocol).orElse(null);
    }

    public String getSchemaRegistryUrl(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getSchemaRegistryUrl).orElse(null);
    }

    public String getSchemaRegistryUsername(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getSchemaRegistryUsername).orElse(null);
    }

    public String getSchemaRegistryPassword(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getSchemaRegistryPassword).orElse(null);
    }

    public String getUsername(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getUsername).orElse(null);
    }

    public String getPassword(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getPassword).orElse(null);
    }

    public String getBootstrapServers(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getBootstrapServers).orElse(null);
    }

    public String getConsumerBootstrapServers(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getConsumerBootstrapServers).orElse(null);
    }

    public String getProducerBootstrapServers(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getProducerBootstrapServers).orElse(null);
    }

    public String getAdminClientBootstrapServers(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getAdminClientBootstrapServers).orElse(null);
    }

    public SslProperties getSslProperties(String clusterName) {
        return this.clusterProperties(clusterName).map(ClusterProperties::getSsl).orElse(null);
    }

    public List<String> getErrorStackTraceHashExclusionPatterns() {
        return Stream.concat(this.errorStackTraceHashDefaultExclusionPatterns != null ? this.errorStackTraceHashDefaultExclusionPatterns.stream() : Stream.empty(), this.errorStackTraceHashAdditionalExclusionPatterns != null ? this.errorStackTraceHashAdditionalExclusionPatterns.stream() : Stream.empty()).toList();
    }

    @Generated
    public void setCluster(Map<String, ClusterProperties> cluster) {
        this.cluster = cluster;
    }

    @Generated
    public String getDefaultClusterName() {
        return this.defaultClusterName;
    }

    @Generated
    public String getDefaultProducerClusterOverride() {
        return this.defaultProducerClusterOverride;
    }

    @Generated
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Generated
    public void setConsumerBootstrapServers(String consumerBootstrapServers) {
        this.consumerBootstrapServers = consumerBootstrapServers;
    }

    @Generated
    public void setProducerBootstrapServers(String producerBootstrapServers) {
        this.producerBootstrapServers = producerBootstrapServers;
    }

    @Generated
    public void setAdminClientBootstrapServers(String adminClientBootstrapServers) {
        this.adminClientBootstrapServers = adminClientBootstrapServers;
    }

    @Generated
    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSchemaRegistryUrl(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
    }

    @Generated
    public void setSchemaRegistryUsername(String schemaRegistryUsername) {
        this.schemaRegistryUsername = schemaRegistryUsername;
    }

    @Generated
    public void setSchemaRegistryPassword(String schemaRegistryPassword) {
        this.schemaRegistryPassword = schemaRegistryPassword;
    }

    @Generated
    public void setErrorTopicName(String errorTopicName) {
        this.errorTopicName = errorTopicName;
    }

    @Generated
    public void setAutoRegisterSchema(boolean autoRegisterSchema) {
        this.autoRegisterSchema = autoRegisterSchema;
    }

    @Generated
    public boolean isAutoRegisterSchema() {
        return this.autoRegisterSchema;
    }

    @Generated
    public void setUseSchemaRegistry(boolean useSchemaRegistry) {
        this.useSchemaRegistry = useSchemaRegistry;
    }

    @Generated
    public boolean isUseSchemaRegistry() {
        return this.useSchemaRegistry;
    }

    @Generated
    public void setExposeMessageKeyToConsumer(boolean exposeMessageKeyToConsumer) {
        this.exposeMessageKeyToConsumer = exposeMessageKeyToConsumer;
    }

    @Generated
    public boolean isExposeMessageKeyToConsumer() {
        return this.exposeMessageKeyToConsumer;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setPublishWithoutContractAllowed(boolean publishWithoutContractAllowed) {
        this.publishWithoutContractAllowed = publishWithoutContractAllowed;
    }

    @Generated
    public boolean isPublishWithoutContractAllowed() {
        return this.publishWithoutContractAllowed;
    }

    @Generated
    public void setConsumeWithoutContractAllowed(boolean consumeWithoutContractAllowed) {
        this.consumeWithoutContractAllowed = consumeWithoutContractAllowed;
    }

    @Generated
    public boolean isConsumeWithoutContractAllowed() {
        return this.consumeWithoutContractAllowed;
    }

    @Generated
    public void setSilentIgnoreWithoutContract(boolean silentIgnoreWithoutContract) {
        this.silentIgnoreWithoutContract = silentIgnoreWithoutContract;
    }

    @Generated
    public boolean isSilentIgnoreWithoutContract() {
        return this.silentIgnoreWithoutContract;
    }

    @Generated
    public void setErrorServiceRetryIntervalMs(long errorServiceRetryIntervalMs) {
        this.errorServiceRetryIntervalMs = errorServiceRetryIntervalMs;
    }

    @Generated
    public long getErrorServiceRetryIntervalMs() {
        return this.errorServiceRetryIntervalMs;
    }

    @Generated
    public void setErrorServiceRetryAttempts(long errorServiceRetryAttempts) {
        this.errorServiceRetryAttempts = errorServiceRetryAttempts;
    }

    @Generated
    public long getErrorServiceRetryAttempts() {
        return this.errorServiceRetryAttempts;
    }

    @Generated
    public void setErrorEventStackTraceMaxLength(int errorEventStackTraceMaxLength) {
        this.errorEventStackTraceMaxLength = errorEventStackTraceMaxLength;
    }

    @Generated
    public int getErrorEventStackTraceMaxLength() {
        return this.errorEventStackTraceMaxLength;
    }

    @Generated
    public void setErrorStackTraceHashEnabled(boolean errorStackTraceHashEnabled) {
        this.errorStackTraceHashEnabled = errorStackTraceHashEnabled;
    }

    @Generated
    public boolean isErrorStackTraceHashEnabled() {
        return this.errorStackTraceHashEnabled;
    }

    @Generated
    public void setErrorStackTraceHashDefaultExclusionPatterns(List<String> errorStackTraceHashDefaultExclusionPatterns) {
        this.errorStackTraceHashDefaultExclusionPatterns = errorStackTraceHashDefaultExclusionPatterns;
    }

    @Generated
    public List<String> getErrorStackTraceHashDefaultExclusionPatterns() {
        return this.errorStackTraceHashDefaultExclusionPatterns;
    }

    @Generated
    public void setErrorStackTraceHashAdditionalExclusionPatterns(List<String> errorStackTraceHashAdditionalExclusionPatterns) {
        this.errorStackTraceHashAdditionalExclusionPatterns = errorStackTraceHashAdditionalExclusionPatterns;
    }

    @Generated
    public List<String> getErrorStackTraceHashAdditionalExclusionPatterns() {
        return this.errorStackTraceHashAdditionalExclusionPatterns;
    }

    @Generated
    public void setMessageTypeEncryptionDisabled(boolean messageTypeEncryptionDisabled) {
        this.messageTypeEncryptionDisabled = messageTypeEncryptionDisabled;
    }

    @Generated
    public boolean isMessageTypeEncryptionDisabled() {
        return this.messageTypeEncryptionDisabled;
    }
}

