/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth;

import ch.admin.bit.jeap.messaging.kafka.properties.PropertyRequirements;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.SslProperties;
import java.util.Map;

public final class KafkaTrustStoreUtility {
    private static final String TRUST_STORE_PROPERTY_NAME = "javax.net.ssl.trustStore";
    private static final String TRUST_STORE_PASSWORD_PROPERTY_NAME = "javax.net.ssl.trustStorePassword";

    public static void setTrustStorePropertiesFromSslProperties(Map<String, Object> props, SslProperties sslProperties) {
        if (sslProperties.getTrustStoreLocation() != null) {
            props.put("ssl.truststore.location", sslProperties.getTrustStoreLocation());
            if (sslProperties.getTrustStorePassword() != null) {
                props.put("ssl.truststore.password", sslProperties.getTrustStorePassword());
            } else {
                props.remove("ssl.truststore.password");
            }
            if (sslProperties.getTrustStoreType() != null) {
                props.put("ssl.truststore.type", sslProperties.getTrustStoreType());
            } else {
                props.remove("ssl.truststore.type");
            }
        }
    }

    public static void setTrustStorePropertiesFromSystemProperties(Map<String, Object> props, boolean requiredLocation, boolean requiredPassword) {
        KafkaTrustStoreUtility.setTrustStorePropertyFromSystemProperty(props, requiredLocation, TRUST_STORE_PROPERTY_NAME, "ssl.truststore.location");
        KafkaTrustStoreUtility.setTrustStorePropertyFromSystemProperty(props, requiredPassword, TRUST_STORE_PASSWORD_PROPERTY_NAME, "ssl.truststore.password");
    }

    private static void setTrustStorePropertyFromSystemProperty(Map<String, Object> props, boolean required, String systemPropertyName, String targetPropertyName) {
        String value = System.getProperty(systemPropertyName);
        if (required) {
            PropertyRequirements.requireNonNullValue(systemPropertyName, value);
        }
        if (value != null) {
            props.put(targetPropertyName, value);
        }
    }
}

