/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.tracing;

import brave.Span;
import brave.Tracer;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import ch.admin.bit.jeap.messaging.kafka.tracing.TracerBridge;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleuthTracerBridge
implements TracerBridge {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SleuthTracerBridge.class);
    public static final String ORIGINAL_TRACE_HEADERS_PREFIX = "jeap-trace-original-";
    private final Tracer tracer;
    private final TraceContext.Extractor<Headers> extractor;
    private final TraceContext.Injector<Headers> injector;
    private final TraceContext.Extractor<Headers> originalTraceBackupExtractor;
    private final TraceContext.Injector<Headers> originalTraceBackupInjector;

    public SleuthTracerBridge(Tracer tracer, MessagingTracing messagingTracing) {
        this.tracer = tracer;
        Propagation propagation = messagingTracing.tracing().propagation();
        this.extractor = propagation.extractor(SleuthTracerBridge::propagationGetter);
        this.injector = propagation.injector(SleuthTracerBridge::propagationSetter);
        this.originalTraceBackupExtractor = propagation.extractor(SleuthTracerBridge::originalTraceBackupPropagationGetter);
        this.originalTraceBackupInjector = propagation.injector(SleuthTracerBridge::originalTraceBackupPropagationSetter);
    }

    @Override
    public TracerBridge.TracerBridgeElement getSpan(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)record.headers());
        if (extracted.context() != null) {
            log.trace("Tracing context for new span from consumer record is trace id = {}, span id = {}, parent id = {}.", new Object[]{extracted.context().traceIdString(), extracted.context().spanIdString(), extracted.context().parentIdString()});
            Span span = this.tracer.nextSpan(extracted);
            log.trace("Starting new child span with trace id = {}, span id = {}, parent id = {}.", new Object[]{span.context().traceIdString(), span.context().spanIdString(), span.context().parentIdString()});
            Tracer.SpanInScope spanInScope = this.tracer.withSpanInScope(span.start());
            return () -> {
                spanInScope.close();
                span.finish();
            };
        }
        log.trace("Not starting a span because no tracing context could be found in the consumer record.");
        return () -> {};
    }

    @Override
    public void backupOriginalTraceContext(ConsumerRecord<?, ?> record) {
        Headers headers = record.headers();
        TraceContextOrSamplingFlags contextOrSamplingFlagsExtracted = this.extractor.extract((Object)headers);
        TraceContext context = contextOrSamplingFlagsExtracted.context();
        if (context != null) {
            log.trace("Backing up tracing context from consumer record: trace id = {}, span id = {}, parent id = {}.", new Object[]{context.traceIdString(), context.spanIdString(), context.parentIdString()});
            this.originalTraceBackupInjector.inject(context, (Object)headers);
        }
    }

    @Override
    public void restoreOriginalTraceContext(ConsumerRecord<?, ?> record) {
        Headers headers = record.headers();
        TraceContextOrSamplingFlags contextOrSamplingFlagsExtracted = this.originalTraceBackupExtractor.extract((Object)headers);
        TraceContext context = contextOrSamplingFlagsExtracted.context();
        if (context != null) {
            log.trace("Restoring tracing context to consumer record: trace id = {}, span id = {} and parent id = {}.", new Object[]{context.traceIdString(), context.spanIdString(), context.parentIdString()});
            this.injector.inject(context, (Object)headers);
            this.removeOriginalTraceContextHeaders(headers);
        }
    }

    private void removeOriginalTraceContextHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            String key = ((Header)i.next()).key();
            if (key == null || !key.startsWith(ORIGINAL_TRACE_HEADERS_PREFIX)) continue;
            i.remove();
        }
    }

    private static String propagationGetter(Headers headers, String name) {
        Header header = headers.lastHeader(name);
        if (header == null || header.value() == null) {
            return null;
        }
        return new String(header.value(), StandardCharsets.UTF_8);
    }

    private static String originalTraceBackupPropagationGetter(Headers headers, String name) {
        return SleuthTracerBridge.propagationGetter(headers, SleuthTracerBridge.toOriginalTraceHeaderName(name));
    }

    private static void propagationSetter(Headers headers, String name, String value) {
        try {
            headers.remove(name);
            headers.add(name, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalStateException e) {
            log.error("Unable to set header {} in headers {}.", new Object[]{name, headers, e});
        }
    }

    private static void originalTraceBackupPropagationSetter(Headers headers, String name, String value) {
        SleuthTracerBridge.propagationSetter(headers, SleuthTracerBridge.toOriginalTraceHeaderName(name), value);
    }

    private static String toOriginalTraceHeaderName(String headername) {
        return ORIGINAL_TRACE_HEADERS_PREFIX + headername;
    }
}

