/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.spring;

import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class JeapKafkaPropertyFactory {
    private final Environment environment;
    private final BeanFactory beanFactory;
    private KafkaProperties springKafkaProperties;
    private ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties jeapKafkaProperties;

    public static JeapKafkaPropertyFactory create(Environment environment, BeanFactory beanFactory) {
        JeapKafkaPropertyFactory jeapKafkaPropertyFactory = new JeapKafkaPropertyFactory(environment, beanFactory);
        jeapKafkaPropertyFactory.initialize();
        return jeapKafkaPropertyFactory;
    }

    private KafkaProperties createSpringKafkaProperties() {
        return (KafkaProperties)Binder.get((Environment)this.environment).bindOrCreate("spring.kafka", KafkaProperties.class);
    }

    private ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties createJeapKafkaProperties() {
        return JeapKafkaPropertyFactory.createJeapKafkaProperties(this.environment);
    }

    public static ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties createJeapKafkaProperties(Environment environment) {
        ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties props = (ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties)Binder.get((Environment)environment).bindOrCreate("jeap.messaging.kafka", ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties.class);
        props.afterPropertiesSet();
        return props;
    }

    public Set<String> getClusterNames() {
        return this.jeapKafkaProperties.clusterNames();
    }

    private void initialize() {
        Environment environment = this.environment;
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
            String propertyValue = this.environment.getProperty("jeap.messaging.kafka.embedded");
            boolean embeddedKafkaPropsDisabled = "false".equals(propertyValue);
            if (!embeddedKafkaPropsDisabled) {
                boolean isEmbeddedKafkaPropertyTrue = Boolean.parseBoolean(propertyValue);
                if (this.beanFactory.containsBean("embeddedKafka") || isEmbeddedKafkaPropertyTrue) {
                    PropertySource<?> embeddedKafkaPropertySource = JeapKafkaPropertyFactory.loadDefaults("jeap-messaging-embedded-kafka.properties");
                    JeapKafkaPropertyFactory.addHighPriorityPropertySource(configurableEnvironment, embeddedKafkaPropertySource);
                    PropertySource<?> embeddedKafkaDefaultsPropertySource = JeapKafkaPropertyFactory.loadDefaults("jeap-messaging-embedded-kafka-defaults.properties");
                    JeapKafkaPropertyFactory.addLowPriorityPropertySource(configurableEnvironment, embeddedKafkaDefaultsPropertySource);
                }
            }
            PropertySource<?> jeapKafkaPropSource = JeapKafkaPropertyFactory.loadDefaults("jeap-messaging-kafka-defaults.properties");
            JeapKafkaPropertyFactory.addLowPriorityPropertySource(configurableEnvironment, jeapKafkaPropSource);
        }
        this.springKafkaProperties = this.createSpringKafkaProperties();
        this.jeapKafkaProperties = this.createJeapKafkaProperties();
    }

    private static void addHighPriorityPropertySource(ConfigurableEnvironment configurableEnvironment, PropertySource<?> source) {
        if (!configurableEnvironment.getPropertySources().contains(source.getName())) {
            configurableEnvironment.getPropertySources().addAfter("systemProperties", source);
        }
    }

    private static void addLowPriorityPropertySource(ConfigurableEnvironment configurableEnvironment, PropertySource<?> source) {
        if (!configurableEnvironment.getPropertySources().contains(source.getName())) {
            configurableEnvironment.getPropertySources().addLast(source);
        }
    }

    private static PropertySource<?> loadDefaults(String path) {
        return (PropertySource)new PropertiesPropertySourceLoader().load(path, (Resource)new ClassPathResource(path)).get(0);
    }

    @Generated
    public JeapKafkaPropertyFactory(Environment environment, BeanFactory beanFactory) {
        this.environment = environment;
        this.beanFactory = beanFactory;
    }

    @Generated
    public KafkaProperties getSpringKafkaProperties() {
        return this.springKafkaProperties;
    }

    @Generated
    public ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties getJeapKafkaProperties() {
        return this.jeapKafkaProperties;
    }
}

