/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateValidationException;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateValidator;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateWithChainValidity;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureSubscriberProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureVerifier;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CertificateAndSignatureVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateAndSignatureVerifier.class);
    private final SignatureCertificateValidator certificateValidator;
    private final SignatureVerifier signatureVerifier;
    private final Set<String> privilegedProducerNames;

    public CertificateAndSignatureVerifier(SignatureCertificateValidator certificateValidator, SignatureVerifier signatureVerifier, SignatureSubscriberProperties signatureSubscriberProperties) {
        this.certificateValidator = certificateValidator;
        this.signatureVerifier = signatureVerifier;
        this.privilegedProducerNames = signatureSubscriberProperties.privilegedProducerCommonNames();
    }

    public boolean verifyKeySignature(byte[] bytesToValidate, byte[] signature, SignatureCertificateWithChainValidity cert) {
        return this.doVerify(bytesToValidate, signature, cert);
    }

    public boolean verifyValueSignature(String serviceName, byte[] bytesToValidate, byte[] signature, SignatureCertificateWithChainValidity cert) {
        this.validatePublisherIsPrivilegedOrNameMatchesCertCommonName(serviceName, cert);
        return this.doVerify(bytesToValidate, signature, cert);
    }

    private boolean doVerify(byte[] bytesToValidate, byte[] signature, SignatureCertificateWithChainValidity cert) {
        this.certificateValidator.validate(cert);
        return this.signatureVerifier.verify(cert.certificate(), bytesToValidate, signature);
    }

    private void validatePublisherIsPrivilegedOrNameMatchesCertCommonName(String serviceName, SignatureCertificateWithChainValidity cert) {
        String commonName = cert.commonName();
        boolean certificateCommonNameMatchesPublisher = Objects.equals(serviceName, commonName);
        boolean certificateCommonNameIsPrivilegedProducer = this.isPrivilegedProducer(cert);
        if (!certificateCommonNameMatchesPublisher && !certificateCommonNameIsPrivilegedProducer) {
            log.error("Service name {} does not match CN of certificate {}", (Object)serviceName, (Object)commonName);
            throw CertificateValidationException.certificateCommonNameNotValid(serviceName, commonName);
        }
    }

    public boolean isPrivilegedProducer(SignatureCertificateWithChainValidity cert) {
        return this.privilegedProducerNames.contains(cert.commonName());
    }
}

