/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignaturePublisherCheck;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.DefaultSignatureService;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignaturePublisherProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.CertificateAndSignatureVerifier;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.DefaultSignatureAuthenticityService;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureSubscriberProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureVerifier;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberCertificatesContainer;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberValidationPropertiesContainer;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration
@EnableConfigurationProperties(value={SignaturePublisherProperties.class, SignatureSubscriberProperties.class})
@EnableScheduling
@ComponentScan
@Import(value={SignatureMetricConfiguration.class})
public class SignatureConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="jeap.messaging.authentication.publisher", name={"signature-key"})
    public SignaturePublisherCheck signaturePublisherCheck(SignaturePublisherProperties signaturePublisherProperties, SignatureVerifier signatureVerifier) {
        return new SignaturePublisherCheck(signaturePublisherProperties, signatureVerifier);
    }

    @Bean
    @ConditionalOnProperty(prefix="jeap.messaging.authentication.publisher", name={"signature-key"})
    public DefaultSignatureService signatureService(SignaturePublisherProperties signaturePublisherProperties, TaskScheduler taskScheduler, Optional<SignatureMetricsService> signatureMetricsService, @Value(value="${spring.application.name}") String applicationName) {
        return new DefaultSignatureService(signaturePublisherProperties, taskScheduler, signatureMetricsService, applicationName);
    }

    @Bean
    public DefaultSignatureAuthenticityService signatureAuthenticityService(SubscriberValidationPropertiesContainer validationPropertiesContainer, CertificateAndSignatureVerifier certificateAndSignatureVerifier, SubscriberCertificatesContainer subscriberCertificatesContainer, Optional<SignatureMetricsService> signatureMetricsService) {
        return new DefaultSignatureAuthenticityService(validationPropertiesContainer, certificateAndSignatureVerifier, subscriberCertificatesContainer, signatureMetricsService);
    }

    @Configuration
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public static class SignatureMetricConfiguration {
        @Bean
        public SignatureMetricsService signatureMetricsService(MeterRegistry meterRegistry, @Value(value="${spring.application.name}") String applicationName) {
            return new SignatureMetricsService(meterRegistry, applicationName);
        }
    }
}

