/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.metrics;

import ch.admin.bit.jeap.messaging.kafka.metrics.KafkaMessagingMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import lombok.Generated;

public class KafkaMeterRegistryMetrics
implements KafkaMessagingMetrics {
    private final MeterRegistry meterRegistry;
    private static final String METRIC_NAME = "jeap_messaging";
    private static final String TAG_BOOTSTRAPSERVERS = "bootstrapservers";
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_TYPE = "type";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_TOPIC = "topic";
    private static final String TAG_VERSION = "version";
    private static final String TAG_SIGNED = "signed";
    private static final String NOT_AVAILABLE = "na";
    private static final String PRODUCER = "producer";
    private static final String CONSUMER = "consumer";

    @Override
    public void incrementSend(String boostrapServers, String applicationName, String topic, String messageType, String messageTypeVersion, Boolean signatureEnabled) {
        this.meterRegistry.counter(METRIC_NAME, (Iterable)this.getTags(boostrapServers, applicationName, topic, messageType, messageTypeVersion, signatureEnabled, PRODUCER)).increment();
    }

    @Override
    public void incrementConsume(String boostrapServers, String applicationName, String topic, String messageType, String messageTypeVersion, boolean signed) {
        this.meterRegistry.counter(METRIC_NAME, (Iterable)this.getTags(boostrapServers, applicationName, topic, messageType, messageTypeVersion, signed, CONSUMER)).increment();
    }

    private Tags getTags(String bootstrapServers, String applicationName, String topic, String messageType, String messageTypeVersion, Boolean signatureEnabled, String type) {
        if (bootstrapServers == null) {
            bootstrapServers = NOT_AVAILABLE;
        }
        if (messageTypeVersion == null) {
            messageTypeVersion = NOT_AVAILABLE;
        }
        return Tags.of((String[])new String[]{TAG_BOOTSTRAPSERVERS, bootstrapServers, TAG_APPLICATION, applicationName, TAG_TOPIC, topic, TAG_MESSAGE, messageType, TAG_SIGNED, signatureEnabled != null && signatureEnabled != false ? "1" : "0", TAG_TYPE, type, TAG_VERSION, messageTypeVersion});
    }

    @Generated
    public KafkaMeterRegistryMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

