/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde;

import ch.admin.bit.jeap.crypto.api.KeyId;
import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.CreateSerializedMessageHolder;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.EmptyKeyDeserializer;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProperties;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

public final class SerdeUtils {
    public static Deserializer<Object> createKeyDeserializer(String clusterName, Supplier<Deserializer<Object>> deserializerProvider, KafkaProperties kafkaProperties, KafkaAvroSerdeProperties serdeProperties) {
        if (kafkaProperties.isExposeMessageKeyToConsumer()) {
            Deserializer<Object> jeapDeserializer = deserializerProvider.get();
            jeapDeserializer.configure(serdeProperties.avroDeserializerProperties(clusterName), true);
            return SerdeUtils.deserializerWithErrorHandling(clusterName, jeapDeserializer, true, serdeProperties);
        }
        return new EmptyKeyDeserializer();
    }

    public static Deserializer<Object> deserializerWithErrorHandling(String clusterName, Deserializer<Object> deserializer, boolean isKey, KafkaAvroSerdeProperties serdeProperties) {
        ErrorHandlingDeserializer errorHandlingValueDeserializer = new ErrorHandlingDeserializer(deserializer);
        errorHandlingValueDeserializer.setFailedDeserializationFunction((Function)new CreateSerializedMessageHolder());
        errorHandlingValueDeserializer.configure(serdeProperties.avroDeserializerProperties(clusterName), isKey);
        return errorHandlingValueDeserializer;
    }

    public static boolean isMessageEncryptedWithJeapCrypto(boolean isKey, Headers headers) {
        return !isKey && headers != null && headers.headers("jeap_encrypted_value").iterator().hasNext();
    }

    public static byte[] decryptIfEncrypted(boolean isKey, JeapKafkaAvroSerdeCryptoConfig cryptoConfig, String topic, byte[] originalBytes, Headers headers) {
        boolean messageEncryptedWithJeapCrypto = SerdeUtils.isMessageEncryptedWithJeapCrypto(isKey, headers);
        if (messageEncryptedWithJeapCrypto) {
            return SerdeUtils.decryptWithJeapCrypto(cryptoConfig, topic, originalBytes);
        }
        return originalBytes;
    }

    public static byte[] decryptWithJeapCrypto(JeapKafkaAvroSerdeCryptoConfig cryptoConfig, String topic, byte[] originalBytes) {
        if (cryptoConfig != null) {
            return cryptoConfig.getKeyIdCryptoServiceForDecryption(originalBytes).decrypt(originalBytes);
        }
        throw new IllegalStateException("The headers of a message on topic '" + topic + "' indicate that the received  message is encrypted but no key id crypto service has been configured for decrypting the message.");
    }

    public static byte[] encryptPayloadIfRequired(boolean isKey, JeapKafkaAvroSerdeCryptoConfig cryptoConfig, Headers headers, Object record, byte[] payload) {
        String messageTypeName;
        Optional<KeyId> keyIdOptional;
        if (!isKey && cryptoConfig != null && (keyIdOptional = cryptoConfig.getKeyIdForMessageTypeName(messageTypeName = SerdeUtils.requireMessageTypeName(record))).isPresent()) {
            KeyId keyId = keyIdOptional.get();
            byte[] encryptedPayload = cryptoConfig.getKeyIdCryptoService(keyId).encrypt(payload, keyId);
            headers.add("jeap_encrypted_value", JeapKafkaAvroSerdeCryptoConfig.ENCRYPTED_VALUE_HEADER_TRUE);
            return encryptedPayload;
        }
        return payload;
    }

    private static String requireMessageTypeName(Object record) {
        if (record instanceof GenericContainer) {
            GenericContainer gc = (GenericContainer)record;
            return gc.getSchema().getName();
        }
        throw new IllegalStateException("The record object is not an instance of GenericContainer - unable to determine Avro schema name.");
    }

    @Generated
    private SerdeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

