/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.metrics;

import ch.admin.bit.jeap.messaging.kafka.metrics.KafkaMessagingMetrics;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureProducerProperties;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.OutboxMetrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import lombok.Generated;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MicrometerOutboxMetrics
implements OutboxMetrics {
    private final MeterRegistry meterRegistry;
    private final DeferredMessageRepository deferredMessageRepository;
    private final FailedMessageRepository failedMessageRepository;
    private final KafkaMessagingMetrics kafkaMessagingMetrics;
    private final SignatureProducerProperties signatureProducerProperties;
    private final String applicationName;
    private int messagesReadyToBeSentCount = -1;
    private int messagesFailedWithoutResendCount = -1;
    private int messagesFailedWithResendCount = -1;
    private Counter messagesPostImmediateDeliveryCommittedCounter;
    private Counter messagesPostImmediateDeliveryRolledBackCounter;
    private Counter messagesPostImmediateDeliveryUnknownTxStateCounter;
    private Counter messagesPostScheduledDeliveryCommittedCounter;
    private Counter messagesPostScheduledDeliveryRolledBackCounter;
    private Counter messagesPostScheduledDeliveryUnknownTxStateCounter;

    @PostConstruct
    void initialize() {
        this.updateGauges();
        Gauge.builder((String)"outbox_messages_ready_to_be_sent_count", () -> this.messagesReadyToBeSentCount).description("Outbox messages ready to be sent (aka 'the lag').").register(this.meterRegistry);
        Gauge.builder((String)"outbox_messages_failed_count", () -> this.messagesFailedWithoutResendCount).tag("resend_status", "resend_disabled").description("Outbox messages in state 'failed' with resend disabled.").register(this.meterRegistry);
        Gauge.builder((String)"outbox_messages_failed_count", () -> this.messagesFailedWithResendCount).tag("resend_status", "resend_enabled").description("Outbox messages in state 'failed' with resend enabled.").register(this.meterRegistry);
        this.messagesPostImmediateDeliveryCommittedCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "immediate").tag("tx_status", "committed").description("Message posts to the outbox for immediate delivery that were committed.").register(this.meterRegistry);
        this.messagesPostImmediateDeliveryRolledBackCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "immediate").tag("tx_status", "rolled_back").description("Message posts to the outbox for immediate delivery that were rolled back.").register(this.meterRegistry);
        this.messagesPostImmediateDeliveryUnknownTxStateCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "immediate").tag("tx_status", "unknown").description("Message posts to the outbox for immediate delivery where the final transaction state is unknown.").register(this.meterRegistry);
        this.messagesPostScheduledDeliveryCommittedCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "scheduled").tag("tx_status", "committed").description("Message posts to the outbox for scheduled delivery that were committed.").register(this.meterRegistry);
        this.messagesPostScheduledDeliveryRolledBackCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "scheduled").tag("tx_status", "rolled_back").description("Message posts to the outbox for scheduled delivery that were rolled back.").register(this.meterRegistry);
        this.messagesPostScheduledDeliveryUnknownTxStateCounter = Counter.builder((String)"outbox_messages_post_total").tag("delivery_type", "scheduled").tag("tx_status", "unknown").description("Message posts to the outbox for scheduled delivery where the final transaction state is unknown.").register(this.meterRegistry);
    }

    @Override
    public void countTransactionalSend(boolean sendImmediately) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.getTransactionalSendCountTxSync().incrementSendCount(sendImmediately);
        } else {
            this.countSendWithoutTxSynchronization(sendImmediately);
        }
    }

    private void countSendWithoutTxSynchronization(boolean sendImmediately) {
        if (sendImmediately) {
            this.incrementMessagesPostImmediateDeliveryUnknownTxStateCounter(1);
        } else {
            this.incrementMessagesPostScheduledDeliveryUnknownTxStateCounter(1);
        }
    }

    @Override
    public void updateGauges() {
        this.messagesReadyToBeSentCount = this.deferredMessageRepository.countMessagesReadyToBeSent();
        this.messagesFailedWithoutResendCount = this.failedMessageRepository.countFailedMessages(false);
        this.messagesFailedWithResendCount = this.failedMessageRepository.countFailedMessages(true);
    }

    @Override
    public void countMessagingSend(String bootstrapServers, String topic, String messageType, String messageTypeVersion) {
        this.kafkaMessagingMetrics.incrementSend(bootstrapServers, this.applicationName, topic, messageType, messageTypeVersion, Boolean.valueOf(this.signatureProducerProperties.isSigningEnabled()));
    }

    void incrementMessagesPostImmediateDeliveryCommittedCount(int amount) {
        this.messagesPostImmediateDeliveryCommittedCounter.increment((double)amount);
    }

    void incrementMessagesPostImmediateDeliveryRolledBackCount(int amount) {
        this.messagesPostImmediateDeliveryRolledBackCounter.increment((double)amount);
    }

    void incrementMessagesPostImmediateDeliveryUnknownTxStateCounter(int amount) {
        this.messagesPostImmediateDeliveryUnknownTxStateCounter.increment((double)amount);
    }

    void incrementMessagesPostScheduledDeliveryCommittedCount(int amount) {
        this.messagesPostScheduledDeliveryCommittedCounter.increment((double)amount);
    }

    void incrementMessagesPostScheduledDeliveryRolledBackCount(int amount) {
        this.messagesPostScheduledDeliveryRolledBackCounter.increment((double)amount);
    }

    void incrementMessagesPostScheduledDeliveryUnknownTxStateCounter(int amount) {
        this.messagesPostScheduledDeliveryUnknownTxStateCounter.increment((double)amount);
    }

    private TransactionalSendCountTxSync getTransactionalSendCountTxSync() {
        return this.getRegisteredTransactionalSendCountTxSync().orElseGet(this::registerNewTransactionalSendCountTxSync);
    }

    private Optional<TransactionalSendCountTxSync> getRegisteredTransactionalSendCountTxSync() {
        return TransactionSynchronizationManager.getSynchronizations().stream().filter(txSync -> txSync instanceof TransactionalSendCountTxSync).map(txSync -> (TransactionalSendCountTxSync)txSync).findFirst();
    }

    private TransactionalSendCountTxSync registerNewTransactionalSendCountTxSync() {
        TransactionalSendCountTxSync transactionalSendCountTxSync = new TransactionalSendCountTxSync(this);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionalSendCountTxSync);
        return transactionalSendCountTxSync;
    }

    @Generated
    public MicrometerOutboxMetrics(MeterRegistry meterRegistry, DeferredMessageRepository deferredMessageRepository, FailedMessageRepository failedMessageRepository, KafkaMessagingMetrics kafkaMessagingMetrics, SignatureProducerProperties signatureProducerProperties, String applicationName) {
        this.meterRegistry = meterRegistry;
        this.deferredMessageRepository = deferredMessageRepository;
        this.failedMessageRepository = failedMessageRepository;
        this.kafkaMessagingMetrics = kafkaMessagingMetrics;
        this.signatureProducerProperties = signatureProducerProperties;
        this.applicationName = applicationName;
    }

    private static class TransactionalSendCountTxSync
    implements TransactionSynchronization {
        private final MicrometerOutboxMetrics micrometerOutboxMetrics;
        private int sendImmediatelyCount;
        private int sendScheduledCount;

        private TransactionalSendCountTxSync(MicrometerOutboxMetrics micrometerOutboxMetrics) {
            this.micrometerOutboxMetrics = micrometerOutboxMetrics;
            this.resetCounters();
        }

        private void incrementSendCount(boolean sendImmediately) {
            if (sendImmediately) {
                ++this.sendImmediatelyCount;
            } else {
                ++this.sendScheduledCount;
            }
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 0: {
                    this.micrometerOutboxMetrics.incrementMessagesPostImmediateDeliveryCommittedCount(this.sendImmediatelyCount);
                    this.micrometerOutboxMetrics.incrementMessagesPostScheduledDeliveryCommittedCount(this.sendScheduledCount);
                    break;
                }
                case 1: {
                    this.micrometerOutboxMetrics.incrementMessagesPostImmediateDeliveryRolledBackCount(this.sendImmediatelyCount);
                    this.micrometerOutboxMetrics.incrementMessagesPostScheduledDeliveryRolledBackCount(this.sendScheduledCount);
                    break;
                }
                default: {
                    this.micrometerOutboxMetrics.incrementMessagesPostImmediateDeliveryUnknownTxStateCounter(this.sendImmediatelyCount);
                    this.micrometerOutboxMetrics.incrementMessagesPostScheduledDeliveryUnknownTxStateCounter(this.sendScheduledCount);
                }
            }
            this.resetCounters();
        }

        private void resetCounters() {
            this.sendImmediatelyCount = 0;
            this.sendScheduledCount = 0;
        }
    }
}

