/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.outbox;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.OutboxTraceContext;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.SendFailureReason;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="deferred_message")
public class DeferredMessage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="dm_sequence")
    @SequenceGenerator(name="dm_sequence", sequenceName="deferred_message_sequence", allocationSize=1)
    @Column(name="id")
    private Long id;
    @Column(name="message")
    private byte[] message;
    @Column(name="`key`")
    private byte[] key;
    @Column(name="clusterName")
    private String clusterName;
    @Column(name="topic")
    private String topic;
    @Column(name="message_id")
    private String messageId;
    @Column(name="message_idempotence_id")
    private String messageIdempotenceId;
    @Column(name="message_type_name")
    private String messageTypeName;
    @Column(name="message_type_version")
    private String messageTypeVersion;
    @Column(name="created")
    private ZonedDateTime created;
    @Column(name="send_immediately")
    private boolean sendImmediately;
    @Column(name="schedule_after")
    private ZonedDateTime scheduleAfter;
    @Column(name="sent_immediately")
    private ZonedDateTime sentImmediately;
    @Column(name="sent_scheduled")
    private ZonedDateTime sentScheduled;
    @Column(name="failed")
    private ZonedDateTime failed;
    @Enumerated(value=EnumType.STRING)
    @Column(name="fail_reason")
    private SendFailureReason failReason;
    @Column(name="resend")
    private boolean resend;
    @Embedded
    private OutboxTraceContext traceContext;

    public static DeferredMessage createDeferredMessage(@NonNull byte[] message, byte[] key, String clusterName, @NonNull String topic, @NonNull String messageId, @NonNull String messageIdempotenceId, @NonNull String messageTypeName, String messageTypeVersion, boolean sendImmediately, OutboxTraceContext traceContext) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (messageIdempotenceId == null) {
            throw new NullPointerException("messageIdempotenceId is marked non-null but is null");
        }
        if (messageTypeName == null) {
            throw new NullPointerException("messageTypeName is marked non-null but is null");
        }
        return new DeferredMessage(null, message, key, clusterName, topic, messageId, messageIdempotenceId, messageTypeName, messageTypeVersion, ZonedDateTime.now(), sendImmediately, null, null, null, null, null, false, traceContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeferredMessage)) {
            return false;
        }
        DeferredMessage other = (DeferredMessage)o;
        return this.id != null && this.id.equals(other.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Generated
    public static DeferredMessageBuilder builder() {
        return new DeferredMessageBuilder();
    }

    @Generated
    private DeferredMessage(Long id, byte[] message, byte[] key, String clusterName, String topic, String messageId, String messageIdempotenceId, String messageTypeName, String messageTypeVersion, ZonedDateTime created, boolean sendImmediately, ZonedDateTime scheduleAfter, ZonedDateTime sentImmediately, ZonedDateTime sentScheduled, ZonedDateTime failed, SendFailureReason failReason, boolean resend, OutboxTraceContext traceContext) {
        this.id = id;
        this.message = message;
        this.key = key;
        this.clusterName = clusterName;
        this.topic = topic;
        this.messageId = messageId;
        this.messageIdempotenceId = messageIdempotenceId;
        this.messageTypeName = messageTypeName;
        this.messageTypeVersion = messageTypeVersion;
        this.created = created;
        this.sendImmediately = sendImmediately;
        this.scheduleAfter = scheduleAfter;
        this.sentImmediately = sentImmediately;
        this.sentScheduled = sentScheduled;
        this.failed = failed;
        this.failReason = failReason;
        this.resend = resend;
        this.traceContext = traceContext;
    }

    @Generated
    protected DeferredMessage() {
    }

    @Generated
    public String toString() {
        return "DeferredMessage(id=" + this.getId() + ", clusterName=" + this.getClusterName() + ", topic=" + this.getTopic() + ", messageId=" + this.getMessageId() + ", messageIdempotenceId=" + this.getMessageIdempotenceId() + ", messageTypeName=" + this.getMessageTypeName() + ", messageTypeVersion=" + this.getMessageTypeVersion() + ", created=" + String.valueOf(this.getCreated()) + ", sendImmediately=" + this.isSendImmediately() + ", scheduleAfter=" + String.valueOf(this.getScheduleAfter()) + ", sentImmediately=" + String.valueOf(this.getSentImmediately()) + ", sentScheduled=" + String.valueOf(this.getSentScheduled()) + ", failed=" + String.valueOf(this.getFailed()) + ", failReason=" + String.valueOf((Object)this.getFailReason()) + ", resend=" + this.isResend() + ", traceContext=" + String.valueOf(this.getTraceContext()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public byte[] getMessage() {
        return this.message;
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getMessageIdempotenceId() {
        return this.messageIdempotenceId;
    }

    @Generated
    public String getMessageTypeName() {
        return this.messageTypeName;
    }

    @Generated
    public String getMessageTypeVersion() {
        return this.messageTypeVersion;
    }

    @Generated
    public ZonedDateTime getCreated() {
        return this.created;
    }

    @Generated
    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    @Generated
    public ZonedDateTime getScheduleAfter() {
        return this.scheduleAfter;
    }

    @Generated
    public ZonedDateTime getSentImmediately() {
        return this.sentImmediately;
    }

    @Generated
    public ZonedDateTime getSentScheduled() {
        return this.sentScheduled;
    }

    @Generated
    public ZonedDateTime getFailed() {
        return this.failed;
    }

    @Generated
    public SendFailureReason getFailReason() {
        return this.failReason;
    }

    @Generated
    public boolean isResend() {
        return this.resend;
    }

    @Generated
    public OutboxTraceContext getTraceContext() {
        return this.traceContext;
    }

    @Generated
    public static class DeferredMessageBuilder {
        @Generated
        private byte[] message;
        @Generated
        private byte[] key;
        @Generated
        private String clusterName;
        @Generated
        private String topic;
        @Generated
        private String messageId;
        @Generated
        private String messageIdempotenceId;
        @Generated
        private String messageTypeName;
        @Generated
        private String messageTypeVersion;
        @Generated
        private boolean sendImmediately;
        @Generated
        private OutboxTraceContext traceContext;

        @Generated
        DeferredMessageBuilder() {
        }

        @Generated
        public DeferredMessageBuilder message(@NonNull byte[] message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public DeferredMessageBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public DeferredMessageBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Generated
        public DeferredMessageBuilder topic(@NonNull String topic) {
            if (topic == null) {
                throw new NullPointerException("topic is marked non-null but is null");
            }
            this.topic = topic;
            return this;
        }

        @Generated
        public DeferredMessageBuilder messageId(@NonNull String messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        @Generated
        public DeferredMessageBuilder messageIdempotenceId(@NonNull String messageIdempotenceId) {
            if (messageIdempotenceId == null) {
                throw new NullPointerException("messageIdempotenceId is marked non-null but is null");
            }
            this.messageIdempotenceId = messageIdempotenceId;
            return this;
        }

        @Generated
        public DeferredMessageBuilder messageTypeName(@NonNull String messageTypeName) {
            if (messageTypeName == null) {
                throw new NullPointerException("messageTypeName is marked non-null but is null");
            }
            this.messageTypeName = messageTypeName;
            return this;
        }

        @Generated
        public DeferredMessageBuilder messageTypeVersion(String messageTypeVersion) {
            this.messageTypeVersion = messageTypeVersion;
            return this;
        }

        @Generated
        public DeferredMessageBuilder sendImmediately(boolean sendImmediately) {
            this.sendImmediately = sendImmediately;
            return this;
        }

        @Generated
        public DeferredMessageBuilder traceContext(OutboxTraceContext traceContext) {
            this.traceContext = traceContext;
            return this;
        }

        @Generated
        public DeferredMessage build() {
            return DeferredMessage.createDeferredMessage(this.message, this.key, this.clusterName, this.topic, this.messageId, this.messageIdempotenceId, this.messageTypeName, this.messageTypeVersion, this.sendImmediately, this.traceContext);
        }

        @Generated
        public String toString() {
            return "DeferredMessage.DeferredMessageBuilder(message=" + Arrays.toString(this.message) + ", key=" + Arrays.toString(this.key) + ", clusterName=" + this.clusterName + ", topic=" + this.topic + ", messageId=" + this.messageId + ", messageIdempotenceId=" + this.messageIdempotenceId + ", messageTypeName=" + this.messageTypeName + ", messageTypeVersion=" + this.messageTypeVersion + ", sendImmediately=" + this.sendImmediately + ", traceContext=" + String.valueOf(this.traceContext) + ")";
        }
    }
}

