/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.spring;

import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import ch.admin.bit.jeap.messaging.transactionaloutbox.spring.OutboxBeanDefinitionFactory;
import ch.admin.bit.jeap.messaging.transactionaloutbox.spring.OutboxBeanNames;
import lombok.Generated;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class OutboxBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    protected Environment environment;
    protected BeanFactory beanFactory;
    private OutboxBeanDefinitionFactory beanDefinitionFactory;
    private OutboxBeanNames outboxBeanNames;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        KafkaProperties kafkaProperties = JeapKafkaPropertyFactory.createJeapKafkaProperties((Environment)this.environment);
        this.outboxBeanNames = new OutboxBeanNames(kafkaProperties.getDefaultClusterName());
        this.beanDefinitionFactory = new OutboxBeanDefinitionFactory(kafkaProperties, new JeapKafkaBeanNames(kafkaProperties.getDefaultClusterName()));
        kafkaProperties.clusterNames().forEach(clusterName -> this.registerOutboxBeanDefinitionsForCluster(registry, (String)clusterName));
    }

    private void registerOutboxBeanDefinitionsForCluster(BeanDefinitionRegistry registry, String clusterName) {
        String serializerBeanName = this.registerSerializerBeanDefinition(registry, clusterName);
        this.registerDeferredMessageSenderBeanDefinition(registry, clusterName);
        this.registerTransactionalOutboxBeanDefinition(registry, clusterName, serializerBeanName);
    }

    private void registerTransactionalOutboxBeanDefinition(BeanDefinitionRegistry registry, String clusterName, String serializerBeanName) {
        String beanName = this.outboxBeanNames.getTransactionalOutboxBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createTransactionalOutboxBeanDefinition(clusterName, serializerBeanName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerDeferredMessageSenderBeanDefinition(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.outboxBeanNames.getDeferredMessageSenderBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createDeferredMessageSenderBeanDefinition(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private String registerSerializerBeanDefinition(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.outboxBeanNames.getOutboxAvroMessageSerializerBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createSerializerBeanDefinition(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
        return beanName;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

