/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.spring;

import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.TransactionalOutbox;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.GenericBeanDefinition;

class OutboxBeanDefinitionFactory {
    private final KafkaProperties kafkaProperties;
    private final JeapKafkaBeanNames jeapKafkaBeanNames;

    GenericBeanDefinition createSerializerBeanDefinition(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName("ch.admin.bit.jeap.messaging.transactionaloutbox.messaging.KafkaAvroMessageSerializer");
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        String serdeBeanName = this.jeapKafkaBeanNames.getKafkaAvroSerdeProviderBeanName(clusterName);
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(serdeBeanName));
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.isPrimaryProducerCluster(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createDeferredMessageSenderBeanDefinition(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName("ch.admin.bit.jeap.messaging.transactionaloutbox.messaging.KafkaDeferredMessageSender");
        beanDefinition.setAutowireMode(3);
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        String producerFactoryBeanName = this.jeapKafkaBeanNames.getProducerFactoryBeanName(clusterName);
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(producerFactoryBeanName));
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.isPrimaryProducerCluster(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createTransactionalOutboxBeanDefinition(String clusterName, String serializerBeanName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(TransactionalOutbox.class);
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        constructorArgs.addGenericArgumentValue((Object)clusterName);
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(serializerBeanName));
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.isPrimaryProducerCluster(clusterName));
        return beanDefinition;
    }

    private boolean isPrimaryProducerCluster(String clusterName) {
        return this.jeapKafkaBeanNames.isPrimaryProducerCluster(this.kafkaProperties.getDefaultProducerClusterOverride(), clusterName);
    }

    @Generated
    public OutboxBeanDefinitionFactory(KafkaProperties kafkaProperties, JeapKafkaBeanNames jeapKafkaBeanNames) {
        this.kafkaProperties = kafkaProperties;
        this.jeapKafkaBeanNames = jeapKafkaBeanNames;
    }
}

