/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.jpa;

import ch.admin.bit.jeap.messaging.transactionaloutbox.jpa.SpringDataJpaDeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.SendFailureReason;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.TransactionalOutboxException;
import io.micrometer.core.annotation.Timed;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class JpaDeferredMessageRepository
implements DeferredMessageRepository,
FailedMessageRepository {
    private static final String FAILED_MESSAGE_CONSTRUCTOR_EXPRESSION = "SELECT NEW ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessage(d.id, d.topic, d.messageId, d.messageIdempotenceId, d.messageTypeName, d.created, d.failed, d.failReason, d.resend) ";
    private static final String FIND_FAILED_MESSAGES_BETWEEN_INSTANTS = "SELECT NEW ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessage(d.id, d.topic, d.messageId, d.messageIdempotenceId, d.messageTypeName, d.created, d.failed, d.failReason, d.resend) FROM DeferredMessage d WHERE d.failed IS NOT NULL AND d.failed >= :failedStartingFrom AND d.failed < :failedBefore AND d.resend = :resend ORDER BY d.id";
    private static final String FIND_FAILED_MESSAGES_STARTING_AFTER_ID = "SELECT NEW ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.FailedMessage(d.id, d.topic, d.messageId, d.messageIdempotenceId, d.messageTypeName, d.created, d.failed, d.failReason, d.resend) FROM DeferredMessage d WHERE d.failed IS NOT NULL AND d.id > :afterId AND d.failed < :failedBefore AND d.resend = :resend ORDER BY d.id";
    private final SpringDataJpaDeferredMessageRepository springDataJpaDeferredMessageRepository;
    @PersistenceContext
    private final EntityManager entityManager;

    @Override
    public DeferredMessage getById(long id) {
        return (DeferredMessage)this.springDataJpaDeferredMessageRepository.getReferenceById(id);
    }

    @Override
    public DeferredMessage save(DeferredMessage deferredMessage) {
        return (DeferredMessage)this.springDataJpaDeferredMessageRepository.save(deferredMessage);
    }

    @Override
    public void deleteById(long id) {
        this.springDataJpaDeferredMessageRepository.deleteById(id);
    }

    @Override
    public void markSentImmediately(long id, ZonedDateTime sentTime) {
        if (this.springDataJpaDeferredMessageRepository.markSentImmediately(id, sentTime) == 0) {
            throw TransactionalOutboxException.deferredMessageNotFoundInOutbox(id);
        }
    }

    @Override
    public void markSentScheduled(long id, ZonedDateTime sentTime) {
        if (this.springDataJpaDeferredMessageRepository.markSentScheduled(id, sentTime) == 0) {
            throw TransactionalOutboxException.deferredMessageNotFoundInOutbox(id);
        }
    }

    @Override
    public void markFailed(long id, ZonedDateTime failedTime, SendFailureReason failReason) {
        if (this.springDataJpaDeferredMessageRepository.markFailed(id, failedTime, failReason) == 0) {
            throw TransactionalOutboxException.deferredMessageNotFoundInOutbox(id);
        }
    }

    @Override
    public void markForResend(long id, boolean resend) {
        if (this.springDataJpaDeferredMessageRepository.markForResend(id, resend) == 0) {
            throw TransactionalOutboxException.deferredMessageNotFoundInOutbox(id);
        }
    }

    @Override
    public void setScheduleAfter(long id, ZonedDateTime scheduleAfter) {
        if (this.springDataJpaDeferredMessageRepository.setScheduleAfter(id, scheduleAfter) == 0) {
            throw TransactionalOutboxException.deferredMessageNotFoundInOutbox(id);
        }
    }

    @Override
    @Timed(value="outbox_messages_ready_to_be_sent_query", description="Search messages ready to be sent.")
    public List<DeferredMessage> findMessagesReadyToBeSent(int numMessages) {
        return this.springDataJpaDeferredMessageRepository.findMessagesReadyToBeSent(numMessages);
    }

    @Override
    public int deleteMessagesSentBefore(ZonedDateTime dateTime) {
        int deleteCount = this.springDataJpaDeferredMessageRepository.countSentImmediatelyBeforeOrSentScheduledBefore(dateTime, dateTime);
        this.springDataJpaDeferredMessageRepository.deleteBySentImmediatelyBeforeOrSentScheduledBefore(dateTime, dateTime);
        return deleteCount;
    }

    @Override
    public int deleteUnsentMessagesCreatedBefore(ZonedDateTime dateTime) {
        int deleteCount = this.springDataJpaDeferredMessageRepository.countSentImmediatelyIsNullAndSentScheduledIsNullAndCreatedBefore(dateTime);
        this.springDataJpaDeferredMessageRepository.deleteBySentImmediatelyIsNullAndSentScheduledIsNullAndCreatedBefore(dateTime);
        return deleteCount;
    }

    @Override
    public int countMessagesReadyToBeSent() {
        return this.springDataJpaDeferredMessageRepository.countMessagesReadyToBeSent();
    }

    @Override
    public int countFailedMessages(boolean resend) {
        return this.springDataJpaDeferredMessageRepository.countByFailedIsNotNullAndResend(resend);
    }

    @Override
    public int countFailedMessages(ZonedDateTime failedStartingFrom, ZonedDateTime failedBefore, boolean resend) {
        return this.springDataJpaDeferredMessageRepository.countFailedBetween(failedStartingFrom, failedBefore, resend);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FailedMessage> findFailedMessages(ZonedDateTime failedStartingFrom, ZonedDateTime failedBefore, boolean resend, int maxNumMessagesToFind) {
        TypedQuery query = this.entityManager.createQuery(FIND_FAILED_MESSAGES_BETWEEN_INSTANTS, FailedMessage.class);
        query.setParameter("failedStartingFrom", (Object)failedStartingFrom);
        query.setParameter("failedBefore", (Object)failedBefore);
        query.setParameter("resend", (Object)resend);
        query.setMaxResults(maxNumMessagesToFind);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<FailedMessage> findFailedMessages(long afterId, ZonedDateTime failedBefore, boolean resend, int maxNumMessagesToFind) {
        TypedQuery query = this.entityManager.createQuery(FIND_FAILED_MESSAGES_STARTING_AFTER_ID, FailedMessage.class);
        query.setParameter("afterId", (Object)afterId);
        query.setParameter("failedBefore", (Object)failedBefore);
        query.setParameter("resend", (Object)resend);
        query.setMaxResults(maxNumMessagesToFind);
        return query.getResultList();
    }

    @Override
    public List<DeferredMessage> findAll() {
        return this.springDataJpaDeferredMessageRepository.findAll();
    }

    @Generated
    public JpaDeferredMessageRepository(SpringDataJpaDeferredMessageRepository springDataJpaDeferredMessageRepository, EntityManager entityManager) {
        this.springDataJpaDeferredMessageRepository = springDataJpaDeferredMessageRepository;
        this.entityManager = entityManager;
    }
}

