/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.outbox;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.TransactionalOutboxConfiguration;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OutboxHouseKeeping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutboxHouseKeeping.class);
    private final DeferredMessageRepository deferredMessageRepository;
    private final TransactionalOutboxConfiguration config;

    public void deleteOldMessages() {
        log.info("House keeping: deleting old messages..");
        ZonedDateTime now = ZonedDateTime.now();
        int deletedSent = this.deferredMessageRepository.deleteMessagesSentBefore(now.minus(this.config.getSentMessageRetentionDuration()));
        int deletedUnsent = this.deferredMessageRepository.deleteUnsentMessagesCreatedBefore(now.minus(this.config.getUnsentMessageRetentionDuration()));
        log.info("House keeping: ..done. Deleted {} sent messages and {} not yet sent messages.", (Object)deletedSent, (Object)deletedUnsent);
    }

    @Generated
    public OutboxHouseKeeping(DeferredMessageRepository deferredMessageRepository, TransactionalOutboxConfiguration config) {
        this.deferredMessageRepository = deferredMessageRepository;
        this.config = config;
    }
}

