/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.spring;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSender;
import ch.admin.bit.jeap.messaging.transactionaloutbox.spring.OutboxBeanNames;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DeferredMessageSenderProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeferredMessageSenderProvider.class);
    private final OutboxBeanNames outboxBeanNames;
    private final Map<String, DeferredMessageSender> deferredMessageSendersByBeanName;
    private final String defaultProducerClusterName;
    private final DeferredMessageSender defaultProducerClusterDeferredMessageSender;

    public DeferredMessageSenderProvider(String defaultClusterName, String defaultProducerClusterName, Map<String, DeferredMessageSender> deferredMessageSendersByBeanName) {
        this.outboxBeanNames = new OutboxBeanNames(defaultClusterName);
        this.deferredMessageSendersByBeanName = deferredMessageSendersByBeanName;
        this.defaultProducerClusterName = defaultProducerClusterName;
        this.defaultProducerClusterDeferredMessageSender = Objects.requireNonNull(this.getDeferredMessageSenderForCluster(defaultProducerClusterName), "Expecting a deferred message sender to exist for the default producer cluster '%s'.".formatted(defaultProducerClusterName));
    }

    public DeferredMessageSender getDeferredMessageSenderForCluster(DeferredMessage message) {
        String clusterName = StringUtils.hasText((String)message.getClusterName()) ? message.getClusterName() : this.defaultProducerClusterName;
        DeferredMessageSender deferredMessageSender = this.getDeferredMessageSenderForCluster(clusterName);
        if (deferredMessageSender == null) {
            log.debug("Unknown cluster name '{}' found in the deferred message {}. Using the default producer cluster '{}' instead.", new Object[]{clusterName, message, this.defaultProducerClusterName});
            deferredMessageSender = this.defaultProducerClusterDeferredMessageSender;
        }
        return deferredMessageSender;
    }

    private DeferredMessageSender getDeferredMessageSenderForCluster(String clusterName) {
        String beanName = this.outboxBeanNames.getDeferredMessageSenderBeanName(clusterName);
        return this.deferredMessageSendersByBeanName.get(beanName);
    }
}

