/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.outbox;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSendException;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSendExceptionHandler;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSender;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.TransactionalOutboxConfiguration;
import ch.admin.bit.jeap.messaging.transactionaloutbox.spring.DeferredMessageSenderProvider;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageRelay {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageRelay.class);
    private final DeferredMessageSenderProvider deferredMessageSenderProvider;
    private final DeferredMessageSendExceptionHandler exceptionHandler;
    private final DeferredMessageRepository deferredMessageRepository;
    private final TransactionalOutboxConfiguration config;

    public void relay() {
        log.debug("Starting to relay deferred messages.");
        ZonedDateTime stopRelayingAt = ZonedDateTime.now().plus(this.config.getContinuousRelayTimeout());
        log.debug("Will stop relaying after {}.", (Object)stopRelayingAt);
        while (ZonedDateTime.now().isBefore(stopRelayingAt)) {
            log.debug("Fetching at most {} deferred messages ready to be sent.", (Object)this.config.getMessageRelayBatchSize());
            List<DeferredMessage> messages = this.deferredMessageRepository.findMessagesReadyToBeSent(this.config.getMessageRelayBatchSize());
            if (messages.isEmpty()) {
                log.debug("There are no deferred messages ready to be sent.");
                break;
            }
            log.debug("Fetched a batch of {} deferred messages to send.", (Object)messages.size());
            try {
                this.sendMessages(messages);
            }
            catch (Exception e) {
                log.error("Unable to send the complete batch of fetched deferred messages.", (Throwable)e);
                break;
            }
        }
        log.debug("Ending relaying of deferred messages.");
    }

    private void sendMessages(List<DeferredMessage> messages) {
        log.debug("Starting to send {} deferred messages.", (Object)messages.size());
        for (DeferredMessage message : messages) {
            this.sendMessage(message);
        }
        log.debug("Ending sending deferred messages.");
    }

    private void sendMessage(DeferredMessage message) {
        try {
            DeferredMessageSender deferredMessageSender = this.deferredMessageSenderProvider.getDeferredMessageSenderForCluster(message);
            deferredMessageSender.sendAsScheduled(message);
            this.deferredMessageRepository.markSentScheduled(message.getId(), ZonedDateTime.now());
        }
        catch (DeferredMessageSendException e) {
            this.exceptionHandler.handle(message, e);
        }
    }

    @Generated
    public MessageRelay(DeferredMessageSenderProvider deferredMessageSenderProvider, DeferredMessageSendExceptionHandler exceptionHandler, DeferredMessageRepository deferredMessageRepository, TransactionalOutboxConfiguration config) {
        this.deferredMessageSenderProvider = deferredMessageSenderProvider;
        this.exceptionHandler = exceptionHandler;
        this.deferredMessageRepository = deferredMessageRepository;
        this.config = config;
    }
}

