/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.messaging;

import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContext;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextProvider;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextUpdater;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.OutboxTraceContext;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.OutboxTracing;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessagingOutboxTracing
implements OutboxTracing {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingOutboxTracing.class);
    private final Optional<TraceContextProvider> traceContextProvider;
    private final Optional<TraceContextUpdater> traceContextUpdater;

    @Override
    public OutboxTraceContext retrieveCurrentTraceContext() {
        if (this.traceContextProvider.isPresent()) {
            TraceContext traceContext = this.traceContextProvider.get().getTraceContext();
            if (traceContext != null) {
                OutboxTraceContext outboxTraceContext = OutboxTraceContext.builder().traceIdHigh(traceContext.getTraceIdHigh()).traceId(traceContext.getTraceId()).spanId(traceContext.getSpanId()).parentSpanId(traceContext.getParentSpanId()).traceIdString(traceContext.getTraceIdString()).build();
                log.debug("Tracing information (traceId={}) found in context. Returning trace context {}", (Object)outboxTraceContext.getTraceIdString(), (Object)outboxTraceContext);
                return outboxTraceContext;
            }
            log.debug("No tracing information available (trace context is null).");
        } else {
            log.debug("No tracing information available (no trace context provider present).");
        }
        return null;
    }

    @Override
    public void updateCurrentTraceContext(OutboxTraceContext outboxTraceContext) {
        if (this.traceContextUpdater.isPresent() && outboxTraceContext != null) {
            log.debug("Original trace context found on the message to send (traceId={}). Overriding the current tracing context with the tracing context {}", (Object)outboxTraceContext.getTraceIdString(), (Object)outboxTraceContext);
            this.traceContextUpdater.get().setTraceContext(new TraceContext(outboxTraceContext.getTraceIdHigh(), outboxTraceContext.getTraceId(), outboxTraceContext.getSpanId(), outboxTraceContext.getParentSpanId(), outboxTraceContext.getTraceIdString()));
        }
    }

    @Generated
    public MessagingOutboxTracing(Optional<TraceContextProvider> traceContextProvider, Optional<TraceContextUpdater> traceContextUpdater) {
        this.traceContextProvider = traceContextProvider;
        this.traceContextUpdater = traceContextUpdater;
    }
}

