/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.outbox;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageLogArgument;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSendException;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeferredMessageSendExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeferredMessageSendExceptionHandler.class);
    private final DeferredMessageRepository deferredMessageRepository;

    public void handle(DeferredMessage deferredMessage, DeferredMessageSendException e) {
        if (!e.getReason().causedByMessage) {
            throw e;
        }
        log.error("Deferred message has an error and cannot be sent. Marking {} as failed.", (Object)DeferredMessageLogArgument.from(deferredMessage), (Object)e);
        this.deferredMessageRepository.markFailed(deferredMessage.getId(), ZonedDateTime.now(), e.getReason());
    }

    @Generated
    public DeferredMessageSendExceptionHandler(DeferredMessageRepository deferredMessageRepository) {
        this.deferredMessageRepository = deferredMessageRepository;
    }
}

