/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.transaction;

import ch.admin.bit.jeap.messaging.transactionaloutbox.config.TransactionalOutboxConfigurationProperties;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.AfterCommitMessageSender;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageRepository;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSendException;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSendExceptionHandler;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessageSender;
import ch.admin.bit.jeap.messaging.transactionaloutbox.spring.DeferredMessageSenderProvider;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class TxSyncAfterCommitMessageSender
implements AfterCommitMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TxSyncAfterCommitMessageSender.class);
    private final DeferredMessageSenderProvider deferredMessageSenderProvider;
    private final DeferredMessageSendExceptionHandler exceptionHandler;
    private final DeferredMessageRepository deferredMessageRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionalOutboxConfigurationProperties config;

    @Override
    public void sendImmediatelyAfterTransactionCommit(DeferredMessage deferredMessage) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            log.warn("Transaction synchronization not available. Skipping immediate send after transaction commit for deferred message ({}).", (Object)this.messageIdLogArgument(deferredMessage));
            return;
        }
        try {
            this.getDeferredMessagesSendingTxSync().addDeferredMessage(deferredMessage);
            log.debug("Registered deferred message ({}) to be sent immediately.", (Object)this.messageIdLogArgument(deferredMessage));
        }
        catch (Exception e) {
            log.warn("Registering deferred message ({}) for after commit send failed. Skipping immediate send.", (Object)this.messageIdLogArgument(deferredMessage), (Object)e);
        }
    }

    private StructuredArgument messageIdLogArgument(DeferredMessage deferredMessage) {
        return StructuredArguments.kv((String)"deferredMessageId", (Object)deferredMessage.getId());
    }

    private DeferredMessagesSendingTxSync getDeferredMessagesSendingTxSync() {
        return this.getRegisteredDeferredMessagesSendingTxSync().orElseGet(this::registerNewDeferredMessagesSendingTxSync);
    }

    private Optional<DeferredMessagesSendingTxSync> getRegisteredDeferredMessagesSendingTxSync() {
        return TransactionSynchronizationManager.getSynchronizations().stream().filter(txSync -> txSync instanceof DeferredMessagesSendingTxSync).map(txSync -> (DeferredMessagesSendingTxSync)txSync).findFirst();
    }

    private DeferredMessagesSendingTxSync registerNewDeferredMessagesSendingTxSync() {
        DeferredMessagesSendingTxSync deferredMessagesSendingTxSync = new DeferredMessagesSendingTxSync(this.deferredMessageSenderProvider, this.config.getMaxDurationSendImmediately(), this.exceptionHandler, this.deferredMessageRepository, this.transactionManager);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)deferredMessagesSendingTxSync);
        return deferredMessagesSendingTxSync;
    }

    @Generated
    public TxSyncAfterCommitMessageSender(DeferredMessageSenderProvider deferredMessageSenderProvider, DeferredMessageSendExceptionHandler exceptionHandler, DeferredMessageRepository deferredMessageRepository, PlatformTransactionManager transactionManager, TransactionalOutboxConfigurationProperties config) {
        this.deferredMessageSenderProvider = deferredMessageSenderProvider;
        this.exceptionHandler = exceptionHandler;
        this.deferredMessageRepository = deferredMessageRepository;
        this.transactionManager = transactionManager;
        this.config = config;
    }

    private static class DeferredMessagesSendingTxSync
    implements TransactionSynchronization {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DeferredMessagesSendingTxSync.class);
        private final DeferredMessageSenderProvider deferredMessageSenderProvider;
        private final Duration maxSendDuration;
        private final DeferredMessageSendExceptionHandler exceptionHandler;
        private final DeferredMessageRepository deferredMessageRepository;
        private final TransactionTemplate transactionTemplate;
        private List<DeferredMessage> deferredMessages = new ArrayList<DeferredMessage>();

        private DeferredMessagesSendingTxSync(DeferredMessageSenderProvider deferredMessageSenderProvider, Duration maxSendDuration, DeferredMessageSendExceptionHandler exceptionHandler, DeferredMessageRepository deferredMessageRepository, PlatformTransactionManager transactionManager) {
            this.deferredMessageSenderProvider = deferredMessageSenderProvider;
            this.maxSendDuration = maxSendDuration;
            this.exceptionHandler = exceptionHandler;
            this.deferredMessageRepository = deferredMessageRepository;
            this.transactionTemplate = new TransactionTemplate(transactionManager);
            this.transactionTemplate.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        }

        private void addDeferredMessage(DeferredMessage deferredMessage) {
            this.deferredMessages.add(deferredMessage);
        }

        public void beforeCommit(boolean readOnly) {
            Duration relayDelay = this.maxSendDuration.multipliedBy(this.deferredMessages.size());
            ZonedDateTime beforeCommitTime = ZonedDateTime.now();
            ZonedDateTime scheduleAfter = beforeCommitTime.plus(relayDelay);
            this.deferredMessages.forEach(deferredMessage -> this.deferredMessageRepository.setScheduleAfter(deferredMessage.getId(), scheduleAfter));
        }

        public void afterCommit() {
            this.executeInNewTransaction(this::sendMessages);
        }

        private void sendMessages() {
            int numSentMessages = 0;
            try {
                for (DeferredMessage deferredMessage : this.deferredMessages) {
                    try {
                        DeferredMessageSender deferredMessageSender = this.deferredMessageSenderProvider.getDeferredMessageSenderForCluster(deferredMessage);
                        deferredMessageSender.sendAsImmediate(deferredMessage);
                        ++numSentMessages;
                        this.deferredMessageRepository.markSentImmediately(deferredMessage.getId(), ZonedDateTime.now());
                    }
                    catch (DeferredMessageSendException e) {
                        this.executeInNewTransaction(() -> this.exceptionHandler.handle(deferredMessage, e));
                    }
                }
            }
            catch (Exception e) {
                int numUnsetMessages = this.deferredMessages.size() - numSentMessages;
                log.warn("Unable to send all deferred messages immediately after transaction commit, {} messages not sent.", (Object)numUnsetMessages, (Object)e);
            }
        }

        public void afterCompletion(int status) {
            this.deferredMessages.clear();
        }

        private void executeInNewTransaction(Runnable r) {
            this.transactionTemplate.executeWithoutResult(status -> r.run());
        }
    }
}

