/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.transactionaloutbox.jpa;

import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.DeferredMessage;
import ch.admin.bit.jeap.messaging.transactionaloutbox.outbox.SendFailureReason;
import java.time.ZonedDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface SpringDataJpaDeferredMessageRepository
extends JpaRepository<DeferredMessage, Long> {
    public static final String READY_TO_BE_SENT_CONDITION = "sent_immediately IS NULL and sent_scheduled IS NULL AND failed IS NULL AND (send_immediately = false OR (send_immediately = true AND CURRENT_TIMESTAMP > schedule_after)) OR resend = true";
    public static final String FROM_SENT_IMMEDIATELY_IS_NULL_AND_SENT_SCHEDULED_IS_NULL_AND_CREATED_BEFORE = "FROM deferred_message d WHERE d.sent_immediately IS NULL AND d.sent_scheduled IS NULL AND d.created < :dateTime ";
    public static final String FROM_SENT_IMMEDIATELY_BEFORE_OR_SCHEDULED_BEFORE = "FROM deferred_message d WHERE d.sent_immediately < :sentImmediatelyBefore OR d.sent_scheduled < :sentScheduledBefore ";

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE DeferredMessage m SET m.sentImmediately = :sentTime WHERE m.id = :id")
    public int markSentImmediately(@Param(value="id") long var1, @Param(value="sentTime") ZonedDateTime var3);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE DeferredMessage m SET m.sentScheduled = :sentTime, m.failed = null, m.resend = false WHERE m.id = :id")
    public int markSentScheduled(@Param(value="id") long var1, @Param(value="sentTime") ZonedDateTime var3);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE DeferredMessage m SET m.failed = :failedTime, m.failReason = :failReason, m.resend = false WHERE m.id = :id")
    public int markFailed(@Param(value="id") long var1, @Param(value="failedTime") ZonedDateTime var3, @Param(value="failReason") SendFailureReason var4);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE DeferredMessage m SET m.resend = :resend WHERE m.id = :id")
    public int markForResend(@Param(value="id") long var1, @Param(value="resend") boolean var3);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE DeferredMessage m SET m.scheduleAfter = :scheduleAfter WHERE m.id = :id")
    public int setScheduleAfter(@Param(value="id") long var1, @Param(value="scheduleAfter") ZonedDateTime var3);

    @Transactional(readOnly=true)
    @Query(nativeQuery=true, value="SELECT * FROM deferred_message WHERE sent_immediately IS NULL and sent_scheduled IS NULL AND failed IS NULL AND (send_immediately = false OR (send_immediately = true AND CURRENT_TIMESTAMP > schedule_after)) OR resend = true order by id limit :numMessages")
    public List<DeferredMessage> findMessagesReadyToBeSent(@Param(value="numMessages") int var1);

    @Transactional
    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM deferred_message d WHERE d.sent_immediately < :sentImmediatelyBefore OR d.sent_scheduled < :sentScheduledBefore ")
    public void deleteBySentImmediatelyBeforeOrSentScheduledBefore(@Param(value="sentImmediatelyBefore") ZonedDateTime var1, @Param(value="sentScheduledBefore") ZonedDateTime var2);

    @Transactional(readOnly=true)
    @Query(nativeQuery=true, value="SELECT count(*) FROM deferred_message d WHERE d.sent_immediately < :sentImmediatelyBefore OR d.sent_scheduled < :sentScheduledBefore ")
    public int countSentImmediatelyBeforeOrSentScheduledBefore(@Param(value="sentImmediatelyBefore") ZonedDateTime var1, @Param(value="sentScheduledBefore") ZonedDateTime var2);

    @Transactional
    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM deferred_message d WHERE d.sent_immediately IS NULL AND d.sent_scheduled IS NULL AND d.created < :dateTime ")
    public void deleteBySentImmediatelyIsNullAndSentScheduledIsNullAndCreatedBefore(@Param(value="dateTime") ZonedDateTime var1);

    @Transactional(readOnly=true)
    @Query(nativeQuery=true, value="select count(*) FROM deferred_message d WHERE d.sent_immediately IS NULL AND d.sent_scheduled IS NULL AND d.created < :dateTime ")
    public int countSentImmediatelyIsNullAndSentScheduledIsNullAndCreatedBefore(@Param(value="dateTime") ZonedDateTime var1);

    @Transactional(readOnly=true)
    @Query(nativeQuery=true, value="SELECT COUNT (*) FROM deferred_message WHERE sent_immediately IS NULL and sent_scheduled IS NULL AND failed IS NULL AND (send_immediately = false OR (send_immediately = true AND CURRENT_TIMESTAMP > schedule_after)) OR resend = true")
    public int countMessagesReadyToBeSent();

    @Transactional(readOnly=true)
    public int countByFailedIsNotNullAndResend(boolean var1);

    @Transactional(readOnly=true)
    @Query(value="SELECT COUNT(d) FROM DeferredMessage d WHERE d.failed IS NOT NULL AND d.failed >= :failedStartingFrom AND d.failed < :failedBefore AND d.resend = :resend")
    public int countFailedBetween(@Param(value="failedStartingFrom") ZonedDateTime var1, @Param(value="failedBefore") ZonedDateTime var2, @Param(value="resend") boolean var3);
}

