/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.housekeeping;

import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="jeap.messaging.sequential-inbox.housekeeping")
public class HouseKeepingConfigProperties {
    private boolean enabled = true;
    @NotNull
    private Duration delay;
    @NotNull
    private Duration maxContinuousHouseKeepingDuration = Duration.ofMinutes(15L);
    private int sequenceRemovalBatchSize = 10;

    @PostConstruct
    void checkConfig() {
        if (this.maxContinuousHouseKeepingDuration.compareTo(Duration.ofMinutes(15L)) > 0) {
            throw new IllegalArgumentException("Sequential inbox house keeping configuration error: max-continuous-house-keeping-duration cannot exceed 15 minutes.");
        }
    }

    @Generated
    public HouseKeepingConfigProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Duration getDelay() {
        return this.delay;
    }

    @Generated
    public Duration getMaxContinuousHouseKeepingDuration() {
        return this.maxContinuousHouseKeepingDuration;
    }

    @Generated
    public int getSequenceRemovalBatchSize() {
        return this.sequenceRemovalBatchSize;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    @Generated
    public void setMaxContinuousHouseKeepingDuration(Duration maxContinuousHouseKeepingDuration) {
        this.maxContinuousHouseKeepingDuration = maxContinuousHouseKeepingDuration;
    }

    @Generated
    public void setSequenceRemovalBatchSize(int sequenceRemovalBatchSize) {
        this.sequenceRemovalBatchSize = sequenceRemovalBatchSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseKeepingConfigProperties)) {
            return false;
        }
        HouseKeepingConfigProperties other = (HouseKeepingConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getSequenceRemovalBatchSize() != other.getSequenceRemovalBatchSize()) {
            return false;
        }
        Duration this$delay = this.getDelay();
        Duration other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Duration this$maxContinuousHouseKeepingDuration = this.getMaxContinuousHouseKeepingDuration();
        Duration other$maxContinuousHouseKeepingDuration = other.getMaxContinuousHouseKeepingDuration();
        return !(this$maxContinuousHouseKeepingDuration == null ? other$maxContinuousHouseKeepingDuration != null : !((Object)this$maxContinuousHouseKeepingDuration).equals(other$maxContinuousHouseKeepingDuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HouseKeepingConfigProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getSequenceRemovalBatchSize();
        Duration $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Duration $maxContinuousHouseKeepingDuration = this.getMaxContinuousHouseKeepingDuration();
        result = result * 59 + ($maxContinuousHouseKeepingDuration == null ? 43 : ((Object)$maxContinuousHouseKeepingDuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HouseKeepingConfigProperties(enabled=" + this.isEnabled() + ", delay=" + String.valueOf(this.getDelay()) + ", maxContinuousHouseKeepingDuration=" + String.valueOf(this.getMaxContinuousHouseKeepingDuration()) + ", sequenceRemovalBatchSize=" + this.getSequenceRemovalBatchSize() + ")";
    }
}

