/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.housekeeping;

import ch.admin.bit.jeap.messaging.sequentialinbox.housekeeping.HouseKeepingConfigProperties;
import ch.admin.bit.jeap.messaging.sequentialinbox.housekeeping.SequentialInboxHouseKeepingException;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.ErrorHandlingService;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.Transactions;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.MessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SequenceInstanceRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import io.micrometer.core.annotation.Timed;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SequentialInboxHousekeepingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxHousekeepingService.class);
    private final MessageRepository messageRepository;
    private final SequenceInstanceRepository sequenceInstanceRepository;
    private final HouseKeepingConfigProperties houseKeepingConfigProperties;
    private final ErrorHandlingService errorHandlingService;
    private final Transactions transactions;

    @Scheduled(cron="${jeap.messaging.sequential-inbox.housekeeping.closed-instances-cron:0 0/15 * * * *}")
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.REPEATABLE_READ)
    @Timed(value="jeap.messaging.sequential-inbox.housekeeping.closed")
    @SchedulerLock(name="sequential-inbox-housekeeping-closed", lockAtLeastFor="5s", lockAtMostFor="1h")
    public void deleteClosedSequenceInstances() {
        log.debug("Starting housekeeping task: deleting closed sequence instances and related data");
        int messagesDeleted = this.messageRepository.deleteMessagesForClosedSequences();
        int sequenceInstancesDeleted = this.sequenceInstanceRepository.deleteAllClosed();
        log.info("Sequential inbox housekeeping completed: deleted {} messages and {} closed sequence instances", (Object)messagesDeleted, (Object)sequenceInstancesDeleted);
    }

    @Scheduled(cron="${jeap.messaging.sequential-inbox.housekeeping.expiry-cron:0 5/15 * * * *}")
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.REPEATABLE_READ)
    @Timed(value="jeap.messaging.sequential-inbox.housekeeping.expired")
    @SchedulerLock(name="sequential-inbox-housekeeping-expired", lockAtLeastFor="5s", lockAtMostFor="1h")
    public void markExpiredSequencesForDelayedRemoval() {
        log.debug("Starting housekeeping task: marking expired sequence instances for removal.");
        int instancesMarkedForRemoval = this.sequenceInstanceRepository.markExpiredInstancesForDelayedRemoval(this.houseKeepingConfigProperties.getDelay().getSeconds());
        log.debug("Sequential inbox housekeeping task completed: marked {} expired sequence instances for removal.", (Object)instancesMarkedForRemoval);
        if (instancesMarkedForRemoval > 0) {
            log.error("Sequential inbox detected {} sequence instances that have expired.", (Object)instancesMarkedForRemoval);
        }
    }

    @Scheduled(cron="${jeap.messaging.sequential-inbox.housekeeping.delete-for-removal-cron:0 10/15 * * * *}")
    @Timed(value="jeap.messaging.sequential-inbox.housekeeping.delete-for-removal")
    @SchedulerLock(name="sequential-inbox-housekeeping-delete-for-removal", lockAtLeastFor="5s", lockAtMostFor="30m")
    public void deleteSequencesReadyForRemoval() {
        ZonedDateTime startedAt = ZonedDateTime.now();
        ZonedDateTime stopAt = startedAt.plus(this.houseKeepingConfigProperties.getMaxContinuousHouseKeepingDuration());
        log.debug("Starting housekeeping task: deleting sequence instances ready for removal until {}.", (Object)stopAt);
        int deletedSequencesTotal = this.deleteSequencesReadyForRemovalInBatches(stopAt);
        ZonedDateTime endedAt = ZonedDateTime.now();
        log.debug("Sequential inbox housekeeping task stopped deleting sequence instances ready for removal at {}. Deleted {} sequence instances in {}.", new Object[]{endedAt, deletedSequencesTotal, Duration.between(startedAt, endedAt)});
    }

    private int deleteSequencesReadyForRemovalInBatches(ZonedDateTime continueDeletingAtMaxUntil) {
        int batchSize = this.houseKeepingConfigProperties.getSequenceRemovalBatchSize();
        log.debug("Sequential inbox housekeeping: Starting to delete sequence instances ready for removal in batches of size {}.", (Object)batchSize);
        int deletedSequencesTotal = 0;
        int batch = 0;
        do {
            List<SequenceInstance> sequencesReadyToBeRemoved;
            if (!(sequencesReadyToBeRemoved = this.findInstancesForRemovalBatch(batchSize)).isEmpty()) {
                log.info("Sequential inbox housekeeping: found {} sequence instances ready for removal in batch {}.", (Object)sequencesReadyToBeRemoved.size(), (Object)(++batch));
                int sequencesDeleted = this.deleteSequencesReadyForRemoval(sequencesReadyToBeRemoved);
                log.info("Sequential inbox housekeeping: deleted {} sequence instances ready for removal in batch {}.", (Object)sequencesDeleted, (Object)batch);
                deletedSequencesTotal += sequencesDeleted;
                continue;
            }
            log.debug("No more sequence instances ready for removal.");
            break;
        } while (continueDeletingAtMaxUntil.isAfter(ZonedDateTime.now()));
        if (deletedSequencesTotal > 0) {
            log.info("Sequential inbox housekeeping: deleted a total of {} sequence instances ready for removal in {} batches.", (Object)deletedSequencesTotal, (Object)batch);
        }
        return deletedSequencesTotal;
    }

    private List<SequenceInstance> findInstancesForRemovalBatch(int batchSize) {
        return this.transactions.callInNewTransaction(() -> this.sequenceInstanceRepository.findInstancesForRemovalOldestFirst(batchSize));
    }

    private int deleteSequencesReadyForRemoval(List<SequenceInstance> sequenceInstances) {
        int numSequencesDeleted = 0;
        for (SequenceInstance sequenceInstance : sequenceInstances) {
            boolean deleted = this.deleteSequenceReadyForRemoval(sequenceInstance);
            if (!deleted) continue;
            ++numSequencesDeleted;
        }
        return numSequencesDeleted;
    }

    private boolean deleteSequenceReadyForRemoval(SequenceInstance sequenceInstance) {
        try {
            return this.transactions.callInNewTransaction(() -> {
                this.sendSequenceInstanceMessagesToErrorHandlingService(sequenceInstance);
                return this.deleteSequenceInstance(sequenceInstance);
            });
        }
        catch (Exception e) {
            log.error("An error occurred trying to delete the sequence instance with id '{}': {}", new Object[]{sequenceInstance.getId(), e.getMessage(), e});
            throw new SequentialInboxHouseKeepingException("An error occurred trying to delete the sequence instance with id '%s'.".formatted(sequenceInstance.getId()), e);
        }
    }

    private void sendSequenceInstanceMessagesToErrorHandlingService(SequenceInstance sequenceInstance) {
        List<SequencedMessage> sequencedMessages = this.messageRepository.getWaitingMessagesInNewTransaction(sequenceInstance.getId());
        for (SequencedMessage sequencedMessage : sequencedMessages) {
            BufferedMessage message = this.messageRepository.getBufferedMessageInNewTransaction(sequencedMessage);
            if (message == null) continue;
            this.errorHandlingService.sendDeletedSequencedMessageToErrorHandler(sequenceInstance, sequencedMessage, message);
        }
    }

    private boolean deleteSequenceInstance(SequenceInstance sequenceInstance) {
        int messagesDeleted = this.messageRepository.deleteNotClosedSequenceInstanceMessages(sequenceInstance.getId());
        int instancesDeleted = this.sequenceInstanceRepository.deleteNotClosedById(sequenceInstance.getId());
        if (instancesDeleted >= 0) {
            log.info("Deleted sequence instance with id '{}' along with {} messages.", (Object)sequenceInstance.getId(), (Object)messagesDeleted);
        }
        return instancesDeleted != 0;
    }

    @Generated
    public SequentialInboxHousekeepingService(MessageRepository messageRepository, SequenceInstanceRepository sequenceInstanceRepository, HouseKeepingConfigProperties houseKeepingConfigProperties, ErrorHandlingService errorHandlingService, Transactions transactions) {
        this.messageRepository = messageRepository;
        this.sequenceInstanceRepository = sequenceInstanceRepository;
        this.houseKeepingConfigProperties = houseKeepingConfigProperties;
        this.errorHandlingService = errorHandlingService;
        this.transactions = transactions;
    }
}

