/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerExceptionInformation;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ErrorServiceSender;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.BufferedMessageTracing;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.DeserializedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.FailedConsumerRecord;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.SequentialInboxDeserializer;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.MessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.stereotype.Component;

@Component
public class ErrorHandlingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlingService.class);
    private final ErrorServiceSender errorServiceSender;
    private final MessageRepository messageRepository;
    private final BufferedMessageTracing bufferedMessageTracing;
    private final SequentialInboxDeserializer inboxDeserializer;

    public void sendDeletedSequencedMessageToErrorHandler(SequenceInstance sequenceInstance, SequencedMessage sequencedMessage, BufferedMessage bufferedMessage) {
        log.debug("Sending deleted sequenced message with id {} from sequence instance id {} to error handler", (Object)sequencedMessage.getId(), (Object)sequenceInstance.getId());
        try (BufferedMessageTracing.TraceContextRestorer ignored = this.bufferedMessageTracing.updateCurrentTraceContext(sequencedMessage.getTraceContext());){
            Map<String, byte[]> headers = this.messageRepository.getHeaders(sequencedMessage);
            Optional<DeserializedMessage> deserializedMessageOpt = this.getDeserializedMessage(sequencedMessage, bufferedMessage);
            deserializedMessageOpt.ifPresent(d -> log.debug("Message with id {} from sequence instance id {} was deserializable.", (Object)sequencedMessage.getId(), (Object)sequenceInstance.getId()));
            FailedConsumerRecord failedConsumerRecord = deserializedMessageOpt.map(deserializedMessage -> FailedConsumerRecord.of(sequencedMessage, headers, deserializedMessage.key(), deserializedMessage.message())).orElseGet(() -> FailedConsumerRecord.of(sequencedMessage, headers, bufferedMessage));
            this.errorServiceSender.accept((ConsumerRecord)failedConsumerRecord, this.createMessageProcessingFailedException(sequenceInstance));
            log.debug("Sent deleted sequenced message with id {} from sequence instance id {} to error handler", (Object)sequencedMessage.getId(), (Object)sequenceInstance.getId());
        }
    }

    private Optional<DeserializedMessage> getDeserializedMessage(SequencedMessage sequencedMessage, BufferedMessage bufferedMessage) {
        try {
            return Optional.of(this.inboxDeserializer.deserialize(sequencedMessage, bufferedMessage));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Exception createMessageProcessingFailedException(SequenceInstance sequenceInstance) {
        InboxSequenceDeletedException isde = new InboxSequenceDeletedException(sequenceInstance);
        return new ListenerExecutionFailedException(isde.getMessage(), (Throwable)isde);
    }

    @Generated
    public ErrorHandlingService(ErrorServiceSender errorServiceSender, MessageRepository messageRepository, BufferedMessageTracing bufferedMessageTracing, SequentialInboxDeserializer inboxDeserializer) {
        this.errorServiceSender = errorServiceSender;
        this.messageRepository = messageRepository;
        this.bufferedMessageTracing = bufferedMessageTracing;
        this.inboxDeserializer = inboxDeserializer;
    }

    static class InboxSequenceDeletedException
    extends RuntimeException
    implements MessageHandlerExceptionInformation {
        private final String message;

        InboxSequenceDeletedException(SequenceInstance sequenceInstance) {
            this.message = "Sequence of type %s with id %s for context %s deleted.".formatted(sequenceInstance.getName(), sequenceInstance.getId(), sequenceInstance.getContextId());
        }

        public String getErrorCode() {
            return "Sequential-Inbox-Sequence-Deleted";
        }

        @Nullable
        public String getDescription() {
            return "This message expired while waiting for its predecessor. Fix the problem with the missing predecessor and then resend this message.";
        }

        public MessageHandlerExceptionInformation.Temporality getTemporality() {
            return MessageHandlerExceptionInformation.Temporality.PERMANENT;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public String getStackTraceAsString() {
            return null;
        }
    }
}

