/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstanceState;
import jakarta.persistence.LockModeType;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
interface SpringDataJpaSequenceInstanceRepository
extends JpaRepository<SequenceInstance, Long> {
    @Query(nativeQuery=true, value="SELECT id FROM sequence_instance WHERE name = ?1 AND context_id = ?2")
    public Optional<Long> findIdByNameAndContextId(String var1, String var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="SELECT si FROM SequenceInstance si WHERE si.id = ?1")
    public SequenceInstance getByIdAndLockForUpdate(long var1);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM sequence_instance WHERE state = 'CLOSED'")
    public int deleteAllClosed();

    @Modifying
    @Query(nativeQuery=true, value="UPDATE sequence_instance\nSET remove_after = retain_until + make_interval(secs => :delaySeconds)\nWHERE remove_after IS NULL AND retain_until < now()\n")
    public int markExpiredInstancesForDelayedRemoval(@Param(value="delaySeconds") long var1);

    public List<SequenceInstance> findByRemoveAfterBeforeAndStateNotOrderByRemoveAfterAsc(ZonedDateTime var1, SequenceInstanceState var2, Pageable var3);

    @Modifying
    @Query(value="DELETE FROM SequenceInstance si WHERE si.id = :id AND si.state <> :state")
    public int deleteByIdAndStateNot(@Param(value="id") long var1, @Param(value="state") SequenceInstanceState var3);
}

