/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ContextIdExtractor;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.MessageFilter;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ReleaseCondition;
import java.util.Set;
import lombok.Generated;

public class SequencedMessageType {
    private String type;
    private String topic;
    private String clusterName;
    private ContextIdExtractor<AvroMessage> contextIdExtractor;
    private MessageFilter<AvroMessage> messageFilter;
    private ReleaseCondition releaseCondition;

    public String toString() {
        return "SequencedMessageType{type='%s',topic=%s,clusterName=%s,contextIdExtractor=%s,messageFilter=%s,releaseCondition=%s}".formatted(this.type, this.topic, this.clusterName, this.contextIdExtractor.getClass().getName(), this.messageFilter != null ? this.messageFilter.getClass().getName() : "null", this.releaseCondition);
    }

    public String extractContextId(AvroMessage message) {
        return this.contextIdExtractor.extractContextId(message);
    }

    public boolean shouldSequenceMessage(AvroMessage value) {
        if (this.messageFilter == null) {
            return true;
        }
        return this.messageFilter.shouldSequence(value);
    }

    public boolean isReleaseConditionSatisfied(Set<String> previouslyReleasedMessageTypes) {
        return this.releaseCondition == null || this.releaseCondition.isSatisfied(previouslyReleasedMessageTypes);
    }

    @Generated
    public static SequencedMessageTypeBuilder builder() {
        return new SequencedMessageTypeBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public ContextIdExtractor<AvroMessage> getContextIdExtractor() {
        return this.contextIdExtractor;
    }

    @Generated
    public MessageFilter<AvroMessage> getMessageFilter() {
        return this.messageFilter;
    }

    @Generated
    public ReleaseCondition getReleaseCondition() {
        return this.releaseCondition;
    }

    @Generated
    public SequencedMessageType(String type, String topic, String clusterName, ContextIdExtractor<AvroMessage> contextIdExtractor, MessageFilter<AvroMessage> messageFilter, ReleaseCondition releaseCondition) {
        this.type = type;
        this.topic = topic;
        this.clusterName = clusterName;
        this.contextIdExtractor = contextIdExtractor;
        this.messageFilter = messageFilter;
        this.releaseCondition = releaseCondition;
    }

    @Generated
    public SequencedMessageType() {
    }

    @Generated
    public static class SequencedMessageTypeBuilder {
        @Generated
        private String type;
        @Generated
        private String topic;
        @Generated
        private String clusterName;
        @Generated
        private ContextIdExtractor<AvroMessage> contextIdExtractor;
        @Generated
        private MessageFilter<AvroMessage> messageFilter;
        @Generated
        private ReleaseCondition releaseCondition;

        @Generated
        SequencedMessageTypeBuilder() {
        }

        @Generated
        public SequencedMessageTypeBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public SequencedMessageTypeBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public SequencedMessageTypeBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Generated
        public SequencedMessageTypeBuilder contextIdExtractor(ContextIdExtractor<AvroMessage> contextIdExtractor) {
            this.contextIdExtractor = contextIdExtractor;
            return this;
        }

        @Generated
        public SequencedMessageTypeBuilder messageFilter(MessageFilter<AvroMessage> messageFilter) {
            this.messageFilter = messageFilter;
            return this;
        }

        @Generated
        public SequencedMessageTypeBuilder releaseCondition(ReleaseCondition releaseCondition) {
            this.releaseCondition = releaseCondition;
            return this;
        }

        @Generated
        public SequencedMessageType build() {
            return new SequencedMessageType(this.type, this.topic, this.clusterName, this.contextIdExtractor, this.messageFilter, this.releaseCondition);
        }

        @Generated
        public String toString() {
            return "SequencedMessageType.SequencedMessageTypeBuilder(type=" + this.type + ", topic=" + this.topic + ", clusterName=" + this.clusterName + ", contextIdExtractor=" + String.valueOf(this.contextIdExtractor) + ", messageFilter=" + String.valueOf(this.messageFilter) + ", releaseCondition=" + String.valueOf(this.releaseCondition) + ")";
        }
    }
}

