/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SpringDataJpaBufferedMessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SpringDataJpaSequencedMessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessageState;
import jakarta.persistence.EntityManager;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class MessageRepository {
    private static final Set<SequencedMessageState> WAITING_AND_PROCESSED_STATE = Set.of(SequencedMessageState.WAITING, SequencedMessageState.PROCESSED);
    private final SpringDataJpaBufferedMessageRepository bufferedMessageRepository;
    private final SpringDataJpaSequencedMessageRepository sequencedMessageRepository;
    private final EntityManager entityManager;

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveMessage(BufferedMessage bufferedMessage, SequencedMessage sequencedMessage) {
        SequencedMessage persistentSequencedMessage = (SequencedMessage)this.sequencedMessageRepository.save(sequencedMessage);
        if (bufferedMessage != null) {
            bufferedMessage.setSequencedMessageId(persistentSequencedMessage.getId());
            this.bufferedMessageRepository.save(bufferedMessage);
        }
        this.entityManager.flush();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public Set<String> getProcessedMessageTypesInSequenceInNewTransaction(SequenceInstance sequenceInstance) {
        return this.sequencedMessageRepository.getProcessedMessageTypesInSequence(sequenceInstance.getId());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public List<SequencedMessage> getWaitingAndProcessedMessagesInNewTransaction(SequenceInstance sequenceInstance) {
        return this.sequencedMessageRepository.findAllBySequenceInstanceIdAndStateIn(sequenceInstance.getId(), WAITING_AND_PROCESSED_STATE);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public BufferedMessage getBufferedMessageInNewTransaction(SequencedMessage sequencedMessage) {
        return this.bufferedMessageRepository.getBySequencedMessageId(sequencedMessage.getId());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public void setMessageStateInNewTransaction(SequencedMessage sequencedMessage, SequencedMessageState sequencedMessageState) {
        this.sequencedMessageRepository.updateStateById(sequencedMessage.getId(), sequencedMessageState.name());
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void setMessageStateInCurrentTransaction(SequencedMessage sequencedMessage, SequencedMessageState sequencedMessageState) {
        this.sequencedMessageRepository.updateStateById(sequencedMessage.getId(), sequencedMessageState.name());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public Optional<SequencedMessage> findByMessageTypeAndIdempotenceIdInNewTransaction(String messageType, String idempotenceId) {
        return this.sequencedMessageRepository.findByMessageTypeAndIdempotenceId(messageType, idempotenceId);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteExpiredMessages(ZonedDateTime cutoffTime) {
        this.bufferedMessageRepository.deleteExpired(cutoffTime);
        return this.sequencedMessageRepository.deleteExpired(cutoffTime);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteMessagesForClosedSequences() {
        this.bufferedMessageRepository.deleteForClosedSequences();
        return this.sequencedMessageRepository.deleteForClosedSequences();
    }

    @Generated
    public MessageRepository(SpringDataJpaBufferedMessageRepository bufferedMessageRepository, SpringDataJpaSequencedMessageRepository sequencedMessageRepository, EntityManager entityManager) {
        this.bufferedMessageRepository = bufferedMessageRepository;
        this.sequencedMessageRepository = sequencedMessageRepository;
        this.entityManager = entityManager;
    }
}

